/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo.internal.netty.handler;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.services.kinesisvideo.PutMediaResponseHandler;
import com.amazonaws.services.kinesisvideo.internal.netty.util.ChannelAttributeKeys;
import com.amazonaws.util.BinaryUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.ByteArrayInputStream;
import java.util.Map;

public class ErrorUnmarshallingHandler
extends ChannelInboundHandlerAdapter {
    private final ByteToMessageDecoder.Cumulator cumulator = ByteToMessageDecoder.MERGE_CUMULATOR;
    private final PutMediaResponseHandler responseHandler;
    private final HttpResponseHandler<AmazonServiceException> errorResponseHandler;
    private final HttpResponse errorResponse;
    private ByteBuf cumulation = Unpooled.EMPTY_BUFFER;
    private boolean notifiedOnFailure;

    public ErrorUnmarshallingHandler(PutMediaResponseHandler responseHandler, HttpResponseHandler<AmazonServiceException> errorResponseHandler, Request<?> request) {
        this.responseHandler = responseHandler;
        this.errorResponseHandler = errorResponseHandler;
        this.errorResponse = new HttpResponse(request, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        io.netty.handler.codec.http.HttpResponse resp;
        if (msg instanceof io.netty.handler.codec.http.HttpResponse && (resp = (io.netty.handler.codec.http.HttpResponse)msg).status().code() >= 300) {
            this.dumpToSdkHttpResponse(resp);
        }
        if (msg instanceof HttpContent) {
            this.cumulateContent(ctx, (HttpContent)msg);
        }
        if (msg instanceof LastHttpContent) {
            try {
                this.responseHandler.onFailure(this.unmarshallError());
            }
            catch (Exception e) {
                this.responseHandler.onFailure(new SdkClientException("Unable to unmarshall error response.", e));
            }
            finally {
                this.notifiedOnFailure = true;
                ctx.close();
            }
        }
    }

    private void dumpToSdkHttpResponse(io.netty.handler.codec.http.HttpResponse resp) {
        this.errorResponse.setStatusCode(resp.status().code());
        this.errorResponse.setStatusText(resp.status().reasonPhrase());
        for (Map.Entry header : resp.headers().entries()) {
            this.errorResponse.addHeader((String)header.getKey(), (String)header.getValue());
        }
    }

    private void cumulateContent(ChannelHandlerContext ctx, HttpContent msg) {
        this.cumulation = this.cumulator.cumulate(ctx.alloc(), this.cumulation, msg.content());
    }

    private AmazonServiceException unmarshallError() throws Exception {
        this.errorResponse.setContent(new ByteArrayInputStream(BinaryUtils.copyBytesFrom(this.cumulation.nioBuffer())));
        return this.errorResponseHandler.handle(this.errorResponse);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!this.notifiedOnFailure) {
            this.notifiedOnFailure = true;
            try {
                this.responseHandler.onFailure(new SdkClientException("Unable to execute HTTP request.", cause));
            }
            finally {
                ctx.channel().close();
            }
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (!this.notifiedOnFailure) {
            this.notifiedOnFailure = true;
            if (!Boolean.TRUE.equals(ctx.channel().attr(ChannelAttributeKeys.FINAL_ACK_RECEIVED).get())) {
                this.responseHandler.onFailure(new SdkClientException("Service closed connection before final AckEvent was received"));
            }
        }
    }
}

