/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideoMediaAsync;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideoMediaAsyncClientBuilder;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideoMediaClient;
import com.amazonaws.services.kinesisvideo.model.GetMediaRequest;
import com.amazonaws.services.kinesisvideo.model.GetMediaResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonKinesisVideoMediaAsyncClient
extends AmazonKinesisVideoMediaClient
implements AmazonKinesisVideoMediaAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonKinesisVideoMediaAsyncClientBuilder asyncBuilder() {
        return AmazonKinesisVideoMediaAsyncClientBuilder.standard();
    }

    AmazonKinesisVideoMediaAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<GetMediaResult> getMediaAsync(GetMediaRequest request) {
        return this.getMediaAsync(request, null);
    }

    @Override
    public Future<GetMediaResult> getMediaAsync(GetMediaRequest request, final AsyncHandler<GetMediaRequest, GetMediaResult> asyncHandler) {
        final GetMediaRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMediaResult>(){

            @Override
            public GetMediaResult call() throws Exception {
                GetMediaResult result = null;
                try {
                    result = AmazonKinesisVideoMediaAsyncClient.this.executeGetMedia(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

