/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.kinesis.AmazonKinesisAsync;
import com.amazonaws.services.kinesis.AmazonKinesisAsyncClientBuilder;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.amazonaws.services.kinesis.model.AddTagsToStreamRequest;
import com.amazonaws.services.kinesis.model.AddTagsToStreamResult;
import com.amazonaws.services.kinesis.model.CreateStreamRequest;
import com.amazonaws.services.kinesis.model.CreateStreamResult;
import com.amazonaws.services.kinesis.model.DecreaseStreamRetentionPeriodRequest;
import com.amazonaws.services.kinesis.model.DecreaseStreamRetentionPeriodResult;
import com.amazonaws.services.kinesis.model.DeleteStreamRequest;
import com.amazonaws.services.kinesis.model.DeleteStreamResult;
import com.amazonaws.services.kinesis.model.DescribeLimitsRequest;
import com.amazonaws.services.kinesis.model.DescribeLimitsResult;
import com.amazonaws.services.kinesis.model.DescribeStreamRequest;
import com.amazonaws.services.kinesis.model.DescribeStreamResult;
import com.amazonaws.services.kinesis.model.DescribeStreamSummaryRequest;
import com.amazonaws.services.kinesis.model.DescribeStreamSummaryResult;
import com.amazonaws.services.kinesis.model.DisableEnhancedMonitoringRequest;
import com.amazonaws.services.kinesis.model.DisableEnhancedMonitoringResult;
import com.amazonaws.services.kinesis.model.EnableEnhancedMonitoringRequest;
import com.amazonaws.services.kinesis.model.EnableEnhancedMonitoringResult;
import com.amazonaws.services.kinesis.model.GetRecordsRequest;
import com.amazonaws.services.kinesis.model.GetRecordsResult;
import com.amazonaws.services.kinesis.model.GetShardIteratorRequest;
import com.amazonaws.services.kinesis.model.GetShardIteratorResult;
import com.amazonaws.services.kinesis.model.IncreaseStreamRetentionPeriodRequest;
import com.amazonaws.services.kinesis.model.IncreaseStreamRetentionPeriodResult;
import com.amazonaws.services.kinesis.model.ListShardsRequest;
import com.amazonaws.services.kinesis.model.ListShardsResult;
import com.amazonaws.services.kinesis.model.ListStreamsRequest;
import com.amazonaws.services.kinesis.model.ListStreamsResult;
import com.amazonaws.services.kinesis.model.ListTagsForStreamRequest;
import com.amazonaws.services.kinesis.model.ListTagsForStreamResult;
import com.amazonaws.services.kinesis.model.MergeShardsRequest;
import com.amazonaws.services.kinesis.model.MergeShardsResult;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import com.amazonaws.services.kinesis.model.PutRecordResult;
import com.amazonaws.services.kinesis.model.PutRecordsRequest;
import com.amazonaws.services.kinesis.model.PutRecordsResult;
import com.amazonaws.services.kinesis.model.RemoveTagsFromStreamRequest;
import com.amazonaws.services.kinesis.model.RemoveTagsFromStreamResult;
import com.amazonaws.services.kinesis.model.SplitShardRequest;
import com.amazonaws.services.kinesis.model.SplitShardResult;
import com.amazonaws.services.kinesis.model.StartStreamEncryptionRequest;
import com.amazonaws.services.kinesis.model.StartStreamEncryptionResult;
import com.amazonaws.services.kinesis.model.StopStreamEncryptionRequest;
import com.amazonaws.services.kinesis.model.StopStreamEncryptionResult;
import com.amazonaws.services.kinesis.model.UpdateShardCountRequest;
import com.amazonaws.services.kinesis.model.UpdateShardCountResult;
import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonKinesisAsyncClient
extends AmazonKinesisClient
implements AmazonKinesisAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonKinesisAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonKinesisAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonKinesisAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonKinesisAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonKinesisAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonKinesisAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonKinesisAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonKinesisAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonKinesisAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonKinesisAsyncClientBuilder asyncBuilder() {
        return AmazonKinesisAsyncClientBuilder.standard();
    }

    AmazonKinesisAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddTagsToStreamResult> addTagsToStreamAsync(AddTagsToStreamRequest request) {
        return this.addTagsToStreamAsync(request, null);
    }

    @Override
    public Future<AddTagsToStreamResult> addTagsToStreamAsync(AddTagsToStreamRequest request, final AsyncHandler<AddTagsToStreamRequest, AddTagsToStreamResult> asyncHandler) {
        final AddTagsToStreamRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AddTagsToStreamResult>(){

            @Override
            public AddTagsToStreamResult call() throws Exception {
                AddTagsToStreamResult result = null;
                try {
                    result = AmazonKinesisAsyncClient.this.executeAddTagsToStream(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateStreamResult> createStreamAsync(CreateStreamRequest request) {
        return this.createStreamAsync(request, null);
    }

    @Override
    public Future<CreateStreamResult> createStreamAsync(CreateStreamRequest request, final AsyncHandler<CreateStreamRequest, CreateStreamResult> asyncHandler) {
        final CreateStreamRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateStreamResult>(){

            @Override
            public CreateStreamResult call() throws Exception {
                CreateStreamResult result = null;
                try {
                    result = AmazonKinesisAsyncClient.this.executeCreateStream(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateStreamResult> createStreamAsync(String streamName, Integer shardCount) {
        return this.createStreamAsync(new CreateStreamRequest().withStreamName(streamName).withShardCount(shardCount));
    }

    @Override
    public Future<CreateStreamResult> createStreamAsync(String streamName, Integer shardCount, AsyncHandler<CreateStreamRequest, CreateStreamResult> asyncHandler) {
        return this.createStreamAsync(new CreateStreamRequest().withStreamName(streamName).withShardCount(shardCount), asyncHandler);
    }

    @Override
    public Future<DecreaseStreamRetentionPeriodResult> decreaseStreamRetentionPeriodAsync(DecreaseStreamRetentionPeriodRequest request) {
        return this.decreaseStreamRetentionPeriodAsync(request, null);
    }

    @Override
    public Future<DecreaseStreamRetentionPeriodResult> decreaseStreamRetentionPeriodAsync(DecreaseStreamRetentionPeriodRequest request, final AsyncHandler<DecreaseStreamRetentionPeriodRequest, DecreaseStreamRetentionPeriodResult> asyncHandler) {
        final DecreaseStreamRetentionPeriodRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DecreaseStreamRetentionPeriodResult>(){

            @Override
            public DecreaseStreamRetentionPeriodResult call() throws Exception {
                DecreaseStreamRetentionPeriodResult result = null;
                try {
                    result = AmazonKinesisAsyncClient.this.executeDecreaseStreamRetentionPeriod(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteStreamResult> deleteStreamAsync(DeleteStreamRequest request) {
        return this.deleteStreamAsync(request, null);
    }

    @Override
    public Future<DeleteStreamResult> deleteStreamAsync(DeleteStreamRequest request, final AsyncHandler<DeleteStreamRequest, DeleteStreamResult> asyncHandler) {
        final DeleteStreamRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteStreamResult>(){

            @Override
            public DeleteStreamResult call() throws Exception {
                DeleteStreamResult result = null;
                try {
                    result = AmazonKinesisAsyncClient.this.executeDeleteStream(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteStreamResult> deleteStreamAsync(String streamName) {
        return this.deleteStreamAsync(new DeleteStreamRequest().withStreamName(streamName));
    }

    @Override
    public Future<DeleteStreamResult> deleteStreamAsync(String streamName, AsyncHandler<DeleteStreamRequest, DeleteStreamResult> asyncHandler) {
        return this.deleteStreamAsync(new DeleteStreamRequest().withStreamName(streamName), asyncHandler);
    }

    @Override
    public Future<DescribeLimitsResult> describeLimitsAsync(DescribeLimitsRequest request) {
        return this.describeLimitsAsync(request, null);
    }

    @Override
    public Future<DescribeLimitsResult> describeLimitsAsync(DescribeLimitsRequest request, final AsyncHandler<DescribeLimitsRequest, DescribeLimitsResult> asyncHandler) {
        final DescribeLimitsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeLimitsResult>(){

            @Override
            public DescribeLimitsResult call() throws Exception {
                DescribeLimitsResult result = null;
                try {
                    result = AmazonKinesisAsyncClient.this.executeDescribeLimits(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeStreamResult> describeStreamAsync(DescribeStreamRequest request) {
        return this.describeStreamAsync(request, null);
    }

    @Override
    public Future<DescribeStreamResult> describeStreamAsync(DescribeStreamRequest request, final AsyncHandler<DescribeStreamRequest, DescribeStreamResult> asyncHandler) {
        final DescribeStreamRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeStreamResult>(){

            @Override
            public DescribeStreamResult call() throws Exception {
                DescribeStreamResult result = null;
                try {
                    result = AmazonKinesisAsyncClient.this.executeDescribeStream(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeStreamResult> describeStreamAsync(String streamName) {
        return this.describeStreamAsync(new DescribeStreamRequest().withStreamName(streamName));
    }

    @Override
    public Future<DescribeStreamResult> describeStreamAsync(String streamName, AsyncHandler<DescribeStreamRequest, DescribeStreamResult> asyncHandler) {
        return this.describeStreamAsync(new DescribeStreamRequest().withStreamName(streamName), asyncHandler);
    }

    @Override
    public Future<DescribeStreamResult> describeStreamAsync(String streamName, String exclusiveStartShardId) {
        return this.describeStreamAsync(new DescribeStreamRequest().withStreamName(streamName).withExclusiveStartShardId(exclusiveStartShardId));
    }

    @Override
    public Future<DescribeStreamResult> describeStreamAsync(String streamName, String exclusiveStartShardId, AsyncHandler<DescribeStreamRequest, DescribeStreamResult> asyncHandler) {
        return this.describeStreamAsync(new DescribeStreamRequest().withStreamName(streamName).withExclusiveStartShardId(exclusiveStartShardId), asyncHandler);
    }

    @Override
    public Future<DescribeStreamResult> describeStreamAsync(String streamName, Integer limit, String exclusiveStartShardId) {
        return this.describeStreamAsync(new DescribeStreamRequest().withStreamName(streamName).withLimit(limit).withExclusiveStartShardId(exclusiveStartShardId));
    }

    @Override
    public Future<DescribeStreamResult> describeStreamAsync(String streamName, Integer limit, String exclusiveStartShardId, AsyncHandler<DescribeStreamRequest, DescribeStreamResult> asyncHandler) {
        return this.describeStreamAsync(new DescribeStreamRequest().withStreamName(streamName).withLimit(limit).withExclusiveStartShardId(exclusiveStartShardId), asyncHandler);
    }

    @Override
    public Future<DescribeStreamSummaryResult> describeStreamSummaryAsync(DescribeStreamSummaryRequest request) {
        return this.describeStreamSummaryAsync(request, null);
    }

    @Override
    public Future<DescribeStreamSummaryResult> describeStreamSummaryAsync(DescribeStreamSummaryRequest request, final AsyncHandler<DescribeStreamSummaryRequest, DescribeStreamSummaryResult> asyncHandler) {
        final DescribeStreamSummaryRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeStreamSummaryResult>(){

            @Override
            public DescribeStreamSummaryResult call() throws Exception {
                DescribeStreamSummaryResult result = null;
                try {
                    result = AmazonKinesisAsyncClient.this.executeDescribeStreamSummary(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisableEnhancedMonitoringResult> disableEnhancedMonitoringAsync(DisableEnhancedMonitoringRequest request) {
        return this.disableEnhancedMonitoringAsync(request, null);
    }

    @Override
    public Future<DisableEnhancedMonitoringResult> disableEnhancedMonitoringAsync(DisableEnhancedMonitoringRequest request, final AsyncHandler<DisableEnhancedMonitoringRequest, DisableEnhancedMonitoringResult> asyncHandler) {
        final DisableEnhancedMonitoringRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisableEnhancedMonitoringResult>(){

            @Override
            public DisableEnhancedMonitoringResult call() throws Exception {
                DisableEnhancedMonitoringResult result = null;
                try {
                    result = AmazonKinesisAsyncClient.this.executeDisableEnhancedMonitoring(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableEnhancedMonitoringResult> enableEnhancedMonitoringAsync(EnableEnhancedMonitoringRequest request) {
        return this.enableEnhancedMonitoringAsync(request, null);
    }

    @Override
    public Future<EnableEnhancedMonitoringResult> enableEnhancedMonitoringAsync(EnableEnhancedMonitoringRequest request, final AsyncHandler<EnableEnhancedMonitoringRequest, EnableEnhancedMonitoringResult> asyncHandler) {
        final EnableEnhancedMonitoringRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EnableEnhancedMonitoringResult>(){

            @Override
            public EnableEnhancedMonitoringResult call() throws Exception {
                EnableEnhancedMonitoringResult result = null;
                try {
                    result = AmazonKinesisAsyncClient.this.executeEnableEnhancedMonitoring(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRecordsResult> getRecordsAsync(GetRecordsRequest request) {
        return this.getRecordsAsync(request, null);
    }

    @Override
    public Future<GetRecordsResult> getRecordsAsync(GetRecordsRequest request, final AsyncHandler<GetRecordsRequest, GetRecordsResult> asyncHandler) {
        final GetRecordsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRecordsResult>(){

            @Override
            public GetRecordsResult call() throws Exception {
                GetRecordsResult result = null;
                try {
                    result = AmazonKinesisAsyncClient.this.executeGetRecords(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetShardIteratorResult> getShardIteratorAsync(GetShardIteratorRequest request) {
        return this.getShardIteratorAsync(request, null);
    }

    @Override
    public Future<GetShardIteratorResult> getShardIteratorAsync(GetShardIteratorRequest request, final AsyncHandler<GetShardIteratorRequest, GetShardIteratorResult> asyncHandler) {
        final GetShardIteratorRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetShardIteratorResult>(){

            @Override
            public GetShardIteratorResult call() throws Exception {
                GetShardIteratorResult result = null;
                try {
                    result = AmazonKinesisAsyncClient.this.executeGetShardIterator(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetShardIteratorResult> getShardIteratorAsync(String streamName, String shardId, String shardIteratorType) {
        return this.getShardIteratorAsync(new GetShardIteratorRequest().withStreamName(streamName).withShardId(shardId).withShardIteratorType(shardIteratorType));
    }

    @Override
    public Future<GetShardIteratorResult> getShardIteratorAsync(String streamName, String shardId, String shardIteratorType, AsyncHandler<GetShardIteratorRequest, GetShardIteratorResult> asyncHandler) {
        return this.getShardIteratorAsync(new GetShardIteratorRequest().withStreamName(streamName).withShardId(shardId).withShardIteratorType(shardIteratorType), asyncHandler);
    }

    @Override
    public Future<GetShardIteratorResult> getShardIteratorAsync(String streamName, String shardId, String shardIteratorType, String startingSequenceNumber) {
        return this.getShardIteratorAsync(new GetShardIteratorRequest().withStreamName(streamName).withShardId(shardId).withShardIteratorType(shardIteratorType).withStartingSequenceNumber(startingSequenceNumber));
    }

    @Override
    public Future<GetShardIteratorResult> getShardIteratorAsync(String streamName, String shardId, String shardIteratorType, String startingSequenceNumber, AsyncHandler<GetShardIteratorRequest, GetShardIteratorResult> asyncHandler) {
        return this.getShardIteratorAsync(new GetShardIteratorRequest().withStreamName(streamName).withShardId(shardId).withShardIteratorType(shardIteratorType).withStartingSequenceNumber(startingSequenceNumber), asyncHandler);
    }

    @Override
    public Future<IncreaseStreamRetentionPeriodResult> increaseStreamRetentionPeriodAsync(IncreaseStreamRetentionPeriodRequest request) {
        return this.increaseStreamRetentionPeriodAsync(request, null);
    }

    @Override
    public Future<IncreaseStreamRetentionPeriodResult> increaseStreamRetentionPeriodAsync(IncreaseStreamRetentionPeriodRequest request, final AsyncHandler<IncreaseStreamRetentionPeriodRequest, IncreaseStreamRetentionPeriodResult> asyncHandler) {
        final IncreaseStreamRetentionPeriodRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<IncreaseStreamRetentionPeriodResult>(){

            @Override
            public IncreaseStreamRetentionPeriodResult call() throws Exception {
                IncreaseStreamRetentionPeriodResult result = null;
                try {
                    result = AmazonKinesisAsyncClient.this.executeIncreaseStreamRetentionPeriod(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListShardsResult> listShardsAsync(ListShardsRequest request) {
        return this.listShardsAsync(request, null);
    }

    @Override
    public Future<ListShardsResult> listShardsAsync(ListShardsRequest request, final AsyncHandler<ListShardsRequest, ListShardsResult> asyncHandler) {
        final ListShardsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListShardsResult>(){

            @Override
            public ListShardsResult call() throws Exception {
                ListShardsResult result = null;
                try {
                    result = AmazonKinesisAsyncClient.this.executeListShards(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListStreamsResult> listStreamsAsync(ListStreamsRequest request) {
        return this.listStreamsAsync(request, null);
    }

    @Override
    public Future<ListStreamsResult> listStreamsAsync(ListStreamsRequest request, final AsyncHandler<ListStreamsRequest, ListStreamsResult> asyncHandler) {
        final ListStreamsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListStreamsResult>(){

            @Override
            public ListStreamsResult call() throws Exception {
                ListStreamsResult result = null;
                try {
                    result = AmazonKinesisAsyncClient.this.executeListStreams(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListStreamsResult> listStreamsAsync() {
        return this.listStreamsAsync(new ListStreamsRequest());
    }

    @Override
    public Future<ListStreamsResult> listStreamsAsync(AsyncHandler<ListStreamsRequest, ListStreamsResult> asyncHandler) {
        return this.listStreamsAsync(new ListStreamsRequest(), asyncHandler);
    }

    @Override
    public Future<ListStreamsResult> listStreamsAsync(String exclusiveStartStreamName) {
        return this.listStreamsAsync(new ListStreamsRequest().withExclusiveStartStreamName(exclusiveStartStreamName));
    }

    @Override
    public Future<ListStreamsResult> listStreamsAsync(String exclusiveStartStreamName, AsyncHandler<ListStreamsRequest, ListStreamsResult> asyncHandler) {
        return this.listStreamsAsync(new ListStreamsRequest().withExclusiveStartStreamName(exclusiveStartStreamName), asyncHandler);
    }

    @Override
    public Future<ListStreamsResult> listStreamsAsync(Integer limit, String exclusiveStartStreamName) {
        return this.listStreamsAsync(new ListStreamsRequest().withLimit(limit).withExclusiveStartStreamName(exclusiveStartStreamName));
    }

    @Override
    public Future<ListStreamsResult> listStreamsAsync(Integer limit, String exclusiveStartStreamName, AsyncHandler<ListStreamsRequest, ListStreamsResult> asyncHandler) {
        return this.listStreamsAsync(new ListStreamsRequest().withLimit(limit).withExclusiveStartStreamName(exclusiveStartStreamName), asyncHandler);
    }

    @Override
    public Future<ListTagsForStreamResult> listTagsForStreamAsync(ListTagsForStreamRequest request) {
        return this.listTagsForStreamAsync(request, null);
    }

    @Override
    public Future<ListTagsForStreamResult> listTagsForStreamAsync(ListTagsForStreamRequest request, final AsyncHandler<ListTagsForStreamRequest, ListTagsForStreamResult> asyncHandler) {
        final ListTagsForStreamRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForStreamResult>(){

            @Override
            public ListTagsForStreamResult call() throws Exception {
                ListTagsForStreamResult result = null;
                try {
                    result = AmazonKinesisAsyncClient.this.executeListTagsForStream(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<MergeShardsResult> mergeShardsAsync(MergeShardsRequest request) {
        return this.mergeShardsAsync(request, null);
    }

    @Override
    public Future<MergeShardsResult> mergeShardsAsync(MergeShardsRequest request, final AsyncHandler<MergeShardsRequest, MergeShardsResult> asyncHandler) {
        final MergeShardsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<MergeShardsResult>(){

            @Override
            public MergeShardsResult call() throws Exception {
                MergeShardsResult result = null;
                try {
                    result = AmazonKinesisAsyncClient.this.executeMergeShards(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<MergeShardsResult> mergeShardsAsync(String streamName, String shardToMerge, String adjacentShardToMerge) {
        return this.mergeShardsAsync(new MergeShardsRequest().withStreamName(streamName).withShardToMerge(shardToMerge).withAdjacentShardToMerge(adjacentShardToMerge));
    }

    @Override
    public Future<MergeShardsResult> mergeShardsAsync(String streamName, String shardToMerge, String adjacentShardToMerge, AsyncHandler<MergeShardsRequest, MergeShardsResult> asyncHandler) {
        return this.mergeShardsAsync(new MergeShardsRequest().withStreamName(streamName).withShardToMerge(shardToMerge).withAdjacentShardToMerge(adjacentShardToMerge), asyncHandler);
    }

    @Override
    public Future<PutRecordResult> putRecordAsync(PutRecordRequest request) {
        return this.putRecordAsync(request, null);
    }

    @Override
    public Future<PutRecordResult> putRecordAsync(PutRecordRequest request, final AsyncHandler<PutRecordRequest, PutRecordResult> asyncHandler) {
        final PutRecordRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutRecordResult>(){

            @Override
            public PutRecordResult call() throws Exception {
                PutRecordResult result = null;
                try {
                    result = AmazonKinesisAsyncClient.this.executePutRecord(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutRecordResult> putRecordAsync(String streamName, ByteBuffer data, String partitionKey) {
        return this.putRecordAsync(new PutRecordRequest().withStreamName(streamName).withData(data).withPartitionKey(partitionKey));
    }

    @Override
    public Future<PutRecordResult> putRecordAsync(String streamName, ByteBuffer data, String partitionKey, AsyncHandler<PutRecordRequest, PutRecordResult> asyncHandler) {
        return this.putRecordAsync(new PutRecordRequest().withStreamName(streamName).withData(data).withPartitionKey(partitionKey), asyncHandler);
    }

    @Override
    public Future<PutRecordResult> putRecordAsync(String streamName, ByteBuffer data, String partitionKey, String sequenceNumberForOrdering) {
        return this.putRecordAsync(new PutRecordRequest().withStreamName(streamName).withData(data).withPartitionKey(partitionKey).withSequenceNumberForOrdering(sequenceNumberForOrdering));
    }

    @Override
    public Future<PutRecordResult> putRecordAsync(String streamName, ByteBuffer data, String partitionKey, String sequenceNumberForOrdering, AsyncHandler<PutRecordRequest, PutRecordResult> asyncHandler) {
        return this.putRecordAsync(new PutRecordRequest().withStreamName(streamName).withData(data).withPartitionKey(partitionKey).withSequenceNumberForOrdering(sequenceNumberForOrdering), asyncHandler);
    }

    @Override
    public Future<PutRecordsResult> putRecordsAsync(PutRecordsRequest request) {
        return this.putRecordsAsync(request, null);
    }

    @Override
    public Future<PutRecordsResult> putRecordsAsync(PutRecordsRequest request, final AsyncHandler<PutRecordsRequest, PutRecordsResult> asyncHandler) {
        final PutRecordsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutRecordsResult>(){

            @Override
            public PutRecordsResult call() throws Exception {
                PutRecordsResult result = null;
                try {
                    result = AmazonKinesisAsyncClient.this.executePutRecords(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveTagsFromStreamResult> removeTagsFromStreamAsync(RemoveTagsFromStreamRequest request) {
        return this.removeTagsFromStreamAsync(request, null);
    }

    @Override
    public Future<RemoveTagsFromStreamResult> removeTagsFromStreamAsync(RemoveTagsFromStreamRequest request, final AsyncHandler<RemoveTagsFromStreamRequest, RemoveTagsFromStreamResult> asyncHandler) {
        final RemoveTagsFromStreamRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveTagsFromStreamResult>(){

            @Override
            public RemoveTagsFromStreamResult call() throws Exception {
                RemoveTagsFromStreamResult result = null;
                try {
                    result = AmazonKinesisAsyncClient.this.executeRemoveTagsFromStream(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SplitShardResult> splitShardAsync(SplitShardRequest request) {
        return this.splitShardAsync(request, null);
    }

    @Override
    public Future<SplitShardResult> splitShardAsync(SplitShardRequest request, final AsyncHandler<SplitShardRequest, SplitShardResult> asyncHandler) {
        final SplitShardRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SplitShardResult>(){

            @Override
            public SplitShardResult call() throws Exception {
                SplitShardResult result = null;
                try {
                    result = AmazonKinesisAsyncClient.this.executeSplitShard(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SplitShardResult> splitShardAsync(String streamName, String shardToSplit, String newStartingHashKey) {
        return this.splitShardAsync(new SplitShardRequest().withStreamName(streamName).withShardToSplit(shardToSplit).withNewStartingHashKey(newStartingHashKey));
    }

    @Override
    public Future<SplitShardResult> splitShardAsync(String streamName, String shardToSplit, String newStartingHashKey, AsyncHandler<SplitShardRequest, SplitShardResult> asyncHandler) {
        return this.splitShardAsync(new SplitShardRequest().withStreamName(streamName).withShardToSplit(shardToSplit).withNewStartingHashKey(newStartingHashKey), asyncHandler);
    }

    @Override
    public Future<StartStreamEncryptionResult> startStreamEncryptionAsync(StartStreamEncryptionRequest request) {
        return this.startStreamEncryptionAsync(request, null);
    }

    @Override
    public Future<StartStreamEncryptionResult> startStreamEncryptionAsync(StartStreamEncryptionRequest request, final AsyncHandler<StartStreamEncryptionRequest, StartStreamEncryptionResult> asyncHandler) {
        final StartStreamEncryptionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartStreamEncryptionResult>(){

            @Override
            public StartStreamEncryptionResult call() throws Exception {
                StartStreamEncryptionResult result = null;
                try {
                    result = AmazonKinesisAsyncClient.this.executeStartStreamEncryption(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopStreamEncryptionResult> stopStreamEncryptionAsync(StopStreamEncryptionRequest request) {
        return this.stopStreamEncryptionAsync(request, null);
    }

    @Override
    public Future<StopStreamEncryptionResult> stopStreamEncryptionAsync(StopStreamEncryptionRequest request, final AsyncHandler<StopStreamEncryptionRequest, StopStreamEncryptionResult> asyncHandler) {
        final StopStreamEncryptionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopStreamEncryptionResult>(){

            @Override
            public StopStreamEncryptionResult call() throws Exception {
                StopStreamEncryptionResult result = null;
                try {
                    result = AmazonKinesisAsyncClient.this.executeStopStreamEncryption(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateShardCountResult> updateShardCountAsync(UpdateShardCountRequest request) {
        return this.updateShardCountAsync(request, null);
    }

    @Override
    public Future<UpdateShardCountResult> updateShardCountAsync(UpdateShardCountRequest request, final AsyncHandler<UpdateShardCountRequest, UpdateShardCountResult> asyncHandler) {
        final UpdateShardCountRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateShardCountResult>(){

            @Override
            public UpdateShardCountResult call() throws Exception {
                UpdateShardCountResult result = null;
                try {
                    result = AmazonKinesisAsyncClient.this.executeUpdateShardCount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

