/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model.transform;

import com.amazonaws.services.glue.model.JsonClassifier;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;
import java.util.Date;

public class JsonClassifierJsonUnmarshaller
implements Unmarshaller<JsonClassifier, JsonUnmarshallerContext> {
    private static JsonClassifierJsonUnmarshaller instance;

    @Override
    public JsonClassifier unmarshall(JsonUnmarshallerContext context) throws Exception {
        JsonClassifier jsonClassifier = new JsonClassifier();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    jsonClassifier.setName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreationTime", targetDepth)) {
                    context.nextToken();
                    jsonClassifier.setCreationTime(context.getUnmarshaller(Date.class).unmarshall(context));
                }
                if (context.testExpression("LastUpdated", targetDepth)) {
                    context.nextToken();
                    jsonClassifier.setLastUpdated(context.getUnmarshaller(Date.class).unmarshall(context));
                }
                if (context.testExpression("Version", targetDepth)) {
                    context.nextToken();
                    jsonClassifier.setVersion(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("JsonPath", targetDepth)) {
                    context.nextToken();
                    jsonClassifier.setJsonPath(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return jsonClassifier;
    }

    public static JsonClassifierJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new JsonClassifierJsonUnmarshaller();
        }
        return instance;
    }
}

