/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.waiters;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathField;
import com.amazonaws.jmespath.JmesPathFlatten;
import com.amazonaws.jmespath.JmesPathProjection;
import com.amazonaws.jmespath.JmesPathSubExpression;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeTargetHealthResult;
import com.amazonaws.waiters.AcceptorPathMatcher;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterState;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

@SdkInternalApi
class TargetDeregistered {
    TargetDeregistered() {
    }

    static class IsUnusedMatcher
    extends WaiterAcceptor<DescribeTargetHealthResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsUnusedMatcher() {
        }

        @Override
        public boolean matches(DescribeTargetHealthResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAll(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"unused\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("TargetHealthDescriptions")), new JmesPathSubExpression(new JmesPathField("TargetHealth"), new JmesPathField("State")));
        }
    }

    static class IsInvalidTargetMatcher
    extends WaiterAcceptor<DescribeTargetHealthResult> {
        IsInvalidTargetMatcher() {
        }

        @Override
        public boolean matches(AmazonServiceException e) {
            return "InvalidTarget".equals(e.getErrorCode());
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }
    }
}

