/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.ReshardingConfiguration;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ModifyReplicationGroupShardConfigurationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String replicationGroupId;
    private Integer nodeGroupCount;
    private Boolean applyImmediately;
    private SdkInternalList<ReshardingConfiguration> reshardingConfiguration;
    private SdkInternalList<String> nodeGroupsToRemove;

    public void setReplicationGroupId(String replicationGroupId) {
        this.replicationGroupId = replicationGroupId;
    }

    public String getReplicationGroupId() {
        return this.replicationGroupId;
    }

    public ModifyReplicationGroupShardConfigurationRequest withReplicationGroupId(String replicationGroupId) {
        this.setReplicationGroupId(replicationGroupId);
        return this;
    }

    public void setNodeGroupCount(Integer nodeGroupCount) {
        this.nodeGroupCount = nodeGroupCount;
    }

    public Integer getNodeGroupCount() {
        return this.nodeGroupCount;
    }

    public ModifyReplicationGroupShardConfigurationRequest withNodeGroupCount(Integer nodeGroupCount) {
        this.setNodeGroupCount(nodeGroupCount);
        return this;
    }

    public void setApplyImmediately(Boolean applyImmediately) {
        this.applyImmediately = applyImmediately;
    }

    public Boolean getApplyImmediately() {
        return this.applyImmediately;
    }

    public ModifyReplicationGroupShardConfigurationRequest withApplyImmediately(Boolean applyImmediately) {
        this.setApplyImmediately(applyImmediately);
        return this;
    }

    public Boolean isApplyImmediately() {
        return this.applyImmediately;
    }

    public List<ReshardingConfiguration> getReshardingConfiguration() {
        if (this.reshardingConfiguration == null) {
            this.reshardingConfiguration = new SdkInternalList();
        }
        return this.reshardingConfiguration;
    }

    public void setReshardingConfiguration(Collection<ReshardingConfiguration> reshardingConfiguration) {
        if (reshardingConfiguration == null) {
            this.reshardingConfiguration = null;
            return;
        }
        this.reshardingConfiguration = new SdkInternalList<ReshardingConfiguration>(reshardingConfiguration);
    }

    public ModifyReplicationGroupShardConfigurationRequest withReshardingConfiguration(ReshardingConfiguration ... reshardingConfiguration) {
        if (this.reshardingConfiguration == null) {
            this.setReshardingConfiguration(new SdkInternalList<ReshardingConfiguration>(reshardingConfiguration.length));
        }
        for (ReshardingConfiguration ele : reshardingConfiguration) {
            this.reshardingConfiguration.add(ele);
        }
        return this;
    }

    public ModifyReplicationGroupShardConfigurationRequest withReshardingConfiguration(Collection<ReshardingConfiguration> reshardingConfiguration) {
        this.setReshardingConfiguration(reshardingConfiguration);
        return this;
    }

    public List<String> getNodeGroupsToRemove() {
        if (this.nodeGroupsToRemove == null) {
            this.nodeGroupsToRemove = new SdkInternalList();
        }
        return this.nodeGroupsToRemove;
    }

    public void setNodeGroupsToRemove(Collection<String> nodeGroupsToRemove) {
        if (nodeGroupsToRemove == null) {
            this.nodeGroupsToRemove = null;
            return;
        }
        this.nodeGroupsToRemove = new SdkInternalList<String>(nodeGroupsToRemove);
    }

    public ModifyReplicationGroupShardConfigurationRequest withNodeGroupsToRemove(String ... nodeGroupsToRemove) {
        if (this.nodeGroupsToRemove == null) {
            this.setNodeGroupsToRemove(new SdkInternalList<String>(nodeGroupsToRemove.length));
        }
        for (String ele : nodeGroupsToRemove) {
            this.nodeGroupsToRemove.add(ele);
        }
        return this;
    }

    public ModifyReplicationGroupShardConfigurationRequest withNodeGroupsToRemove(Collection<String> nodeGroupsToRemove) {
        this.setNodeGroupsToRemove(nodeGroupsToRemove);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReplicationGroupId() != null) {
            sb.append("ReplicationGroupId: ").append(this.getReplicationGroupId()).append(",");
        }
        if (this.getNodeGroupCount() != null) {
            sb.append("NodeGroupCount: ").append(this.getNodeGroupCount()).append(",");
        }
        if (this.getApplyImmediately() != null) {
            sb.append("ApplyImmediately: ").append(this.getApplyImmediately()).append(",");
        }
        if (this.getReshardingConfiguration() != null) {
            sb.append("ReshardingConfiguration: ").append(this.getReshardingConfiguration()).append(",");
        }
        if (this.getNodeGroupsToRemove() != null) {
            sb.append("NodeGroupsToRemove: ").append(this.getNodeGroupsToRemove());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyReplicationGroupShardConfigurationRequest)) {
            return false;
        }
        ModifyReplicationGroupShardConfigurationRequest other = (ModifyReplicationGroupShardConfigurationRequest)obj;
        if (other.getReplicationGroupId() == null ^ this.getReplicationGroupId() == null) {
            return false;
        }
        if (other.getReplicationGroupId() != null && !other.getReplicationGroupId().equals(this.getReplicationGroupId())) {
            return false;
        }
        if (other.getNodeGroupCount() == null ^ this.getNodeGroupCount() == null) {
            return false;
        }
        if (other.getNodeGroupCount() != null && !other.getNodeGroupCount().equals(this.getNodeGroupCount())) {
            return false;
        }
        if (other.getApplyImmediately() == null ^ this.getApplyImmediately() == null) {
            return false;
        }
        if (other.getApplyImmediately() != null && !other.getApplyImmediately().equals(this.getApplyImmediately())) {
            return false;
        }
        if (other.getReshardingConfiguration() == null ^ this.getReshardingConfiguration() == null) {
            return false;
        }
        if (other.getReshardingConfiguration() != null && !other.getReshardingConfiguration().equals(this.getReshardingConfiguration())) {
            return false;
        }
        if (other.getNodeGroupsToRemove() == null ^ this.getNodeGroupsToRemove() == null) {
            return false;
        }
        return other.getNodeGroupsToRemove() == null || other.getNodeGroupsToRemove().equals(this.getNodeGroupsToRemove());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReplicationGroupId() == null ? 0 : this.getReplicationGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getNodeGroupCount() == null ? 0 : this.getNodeGroupCount().hashCode());
        hashCode = 31 * hashCode + (this.getApplyImmediately() == null ? 0 : this.getApplyImmediately().hashCode());
        hashCode = 31 * hashCode + (this.getReshardingConfiguration() == null ? 0 : this.getReshardingConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getNodeGroupsToRemove() == null ? 0 : this.getNodeGroupsToRemove().hashCode());
        return hashCode;
    }

    @Override
    public ModifyReplicationGroupShardConfigurationRequest clone() {
        return (ModifyReplicationGroupShardConfigurationRequest)super.clone();
    }
}

