/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecs.model.Task;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class TaskMarshaller {
    private static final MarshallingInfo<String> TASKARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taskArn").build();
    private static final MarshallingInfo<String> CLUSTERARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clusterArn").build();
    private static final MarshallingInfo<String> TASKDEFINITIONARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taskDefinitionArn").build();
    private static final MarshallingInfo<String> CONTAINERINSTANCEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("containerInstanceArn").build();
    private static final MarshallingInfo<StructuredPojo> OVERRIDES_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("overrides").build();
    private static final MarshallingInfo<String> LASTSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastStatus").build();
    private static final MarshallingInfo<String> DESIREDSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("desiredStatus").build();
    private static final MarshallingInfo<String> CPU_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cpu").build();
    private static final MarshallingInfo<String> MEMORY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("memory").build();
    private static final MarshallingInfo<List> CONTAINERS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("containers").build();
    private static final MarshallingInfo<String> STARTEDBY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startedBy").build();
    private static final MarshallingInfo<Long> VERSION_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").build();
    private static final MarshallingInfo<String> STOPPEDREASON_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stoppedReason").build();
    private static final MarshallingInfo<String> CONNECTIVITY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("connectivity").build();
    private static final MarshallingInfo<Date> CONNECTIVITYAT_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("connectivityAt").build();
    private static final MarshallingInfo<Date> PULLSTARTEDAT_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pullStartedAt").build();
    private static final MarshallingInfo<Date> PULLSTOPPEDAT_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pullStoppedAt").build();
    private static final MarshallingInfo<Date> EXECUTIONSTOPPEDAT_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("executionStoppedAt").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").build();
    private static final MarshallingInfo<Date> STARTEDAT_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startedAt").build();
    private static final MarshallingInfo<Date> STOPPINGAT_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stoppingAt").build();
    private static final MarshallingInfo<Date> STOPPEDAT_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stoppedAt").build();
    private static final MarshallingInfo<String> GROUP_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("group").build();
    private static final MarshallingInfo<String> LAUNCHTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("launchType").build();
    private static final MarshallingInfo<String> PLATFORMVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("platformVersion").build();
    private static final MarshallingInfo<List> ATTACHMENTS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attachments").build();
    private static final TaskMarshaller instance = new TaskMarshaller();

    public static TaskMarshaller getInstance() {
        return instance;
    }

    public void marshall(Task task, ProtocolMarshaller protocolMarshaller) {
        if (task == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(task.getTaskArn(), TASKARN_BINDING);
            protocolMarshaller.marshall(task.getClusterArn(), CLUSTERARN_BINDING);
            protocolMarshaller.marshall(task.getTaskDefinitionArn(), TASKDEFINITIONARN_BINDING);
            protocolMarshaller.marshall(task.getContainerInstanceArn(), CONTAINERINSTANCEARN_BINDING);
            protocolMarshaller.marshall(task.getOverrides(), OVERRIDES_BINDING);
            protocolMarshaller.marshall(task.getLastStatus(), LASTSTATUS_BINDING);
            protocolMarshaller.marshall(task.getDesiredStatus(), DESIREDSTATUS_BINDING);
            protocolMarshaller.marshall(task.getCpu(), CPU_BINDING);
            protocolMarshaller.marshall(task.getMemory(), MEMORY_BINDING);
            protocolMarshaller.marshall(task.getContainers(), CONTAINERS_BINDING);
            protocolMarshaller.marshall(task.getStartedBy(), STARTEDBY_BINDING);
            protocolMarshaller.marshall(task.getVersion(), VERSION_BINDING);
            protocolMarshaller.marshall(task.getStoppedReason(), STOPPEDREASON_BINDING);
            protocolMarshaller.marshall(task.getConnectivity(), CONNECTIVITY_BINDING);
            protocolMarshaller.marshall(task.getConnectivityAt(), CONNECTIVITYAT_BINDING);
            protocolMarshaller.marshall(task.getPullStartedAt(), PULLSTARTEDAT_BINDING);
            protocolMarshaller.marshall(task.getPullStoppedAt(), PULLSTOPPEDAT_BINDING);
            protocolMarshaller.marshall(task.getExecutionStoppedAt(), EXECUTIONSTOPPEDAT_BINDING);
            protocolMarshaller.marshall(task.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall(task.getStartedAt(), STARTEDAT_BINDING);
            protocolMarshaller.marshall(task.getStoppingAt(), STOPPINGAT_BINDING);
            protocolMarshaller.marshall(task.getStoppedAt(), STOPPEDAT_BINDING);
            protocolMarshaller.marshall(task.getGroup(), GROUP_BINDING);
            protocolMarshaller.marshall(task.getLaunchType(), LAUNCHTYPE_BINDING);
            protocolMarshaller.marshall(task.getPlatformVersion(), PLATFORMVERSION_BINDING);
            protocolMarshaller.marshall(task.getAttachments(), ATTACHMENTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

