/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.InstanceCreditSpecificationRequest;
import com.amazonaws.services.ec2.model.ModifyInstanceCreditSpecificationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyInstanceCreditSpecificationRequestMarshaller
implements Marshaller<Request<ModifyInstanceCreditSpecificationRequest>, ModifyInstanceCreditSpecificationRequest> {
    @Override
    public Request<ModifyInstanceCreditSpecificationRequest> marshall(ModifyInstanceCreditSpecificationRequest modifyInstanceCreditSpecificationRequest) {
        SdkInternalList modifyInstanceCreditSpecificationRequestInstanceCreditSpecificationsList;
        if (modifyInstanceCreditSpecificationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyInstanceCreditSpecificationRequest> request = new DefaultRequest<ModifyInstanceCreditSpecificationRequest>(modifyInstanceCreditSpecificationRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyInstanceCreditSpecification");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyInstanceCreditSpecificationRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString(modifyInstanceCreditSpecificationRequest.getClientToken()));
        }
        if (!(modifyInstanceCreditSpecificationRequestInstanceCreditSpecificationsList = (SdkInternalList)modifyInstanceCreditSpecificationRequest.getInstanceCreditSpecifications()).isEmpty() || !modifyInstanceCreditSpecificationRequestInstanceCreditSpecificationsList.isAutoConstruct()) {
            int instanceCreditSpecificationsListIndex = 1;
            for (InstanceCreditSpecificationRequest modifyInstanceCreditSpecificationRequestInstanceCreditSpecificationsListValue : modifyInstanceCreditSpecificationRequestInstanceCreditSpecificationsList) {
                if (modifyInstanceCreditSpecificationRequestInstanceCreditSpecificationsListValue.getInstanceId() != null) {
                    request.addParameter("InstanceCreditSpecification." + instanceCreditSpecificationsListIndex + ".InstanceId", StringUtils.fromString(modifyInstanceCreditSpecificationRequestInstanceCreditSpecificationsListValue.getInstanceId()));
                }
                if (modifyInstanceCreditSpecificationRequestInstanceCreditSpecificationsListValue.getCpuCredits() != null) {
                    request.addParameter("InstanceCreditSpecification." + instanceCreditSpecificationsListIndex + ".CpuCredits", StringUtils.fromString(modifyInstanceCreditSpecificationRequestInstanceCreditSpecificationsListValue.getCpuCredits()));
                }
                ++instanceCreditSpecificationsListIndex;
            }
        }
        return request;
    }
}

