/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.InternetGateway;
import com.amazonaws.services.ec2.model.InternetGatewayAttachment;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.transform.InternetGatewayAttachmentStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.TagStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class InternetGatewayStaxUnmarshaller
implements Unmarshaller<InternetGateway, StaxUnmarshallerContext> {
    private static InternetGatewayStaxUnmarshaller instance;

    @Override
    public InternetGateway unmarshall(StaxUnmarshallerContext context) throws Exception {
        InternetGateway internetGateway = new InternetGateway();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return internetGateway;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("attachmentSet", targetDepth)) {
                    internetGateway.withAttachments(new ArrayList<InternetGatewayAttachment>());
                    continue;
                }
                if (context.testExpression("attachmentSet/item", targetDepth)) {
                    internetGateway.withAttachments(InternetGatewayAttachmentStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("internetGatewayId", targetDepth)) {
                    internetGateway.setInternetGatewayId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("tagSet", targetDepth)) {
                    internetGateway.withTags(new ArrayList<Tag>());
                    continue;
                }
                if (!context.testExpression("tagSet/item", targetDepth)) continue;
                internetGateway.withTags(TagStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return internetGateway;
    }

    public static InternetGatewayStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new InternetGatewayStaxUnmarshaller();
        }
        return instance;
    }
}

