/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costexplorer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.costexplorer.model.DimensionValues;
import com.amazonaws.services.costexplorer.model.TagValues;
import com.amazonaws.services.costexplorer.model.transform.ExpressionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Expression
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Expression> or;
    private List<Expression> and;
    private Expression not;
    private DimensionValues dimensions;
    private TagValues tags;

    public List<Expression> getOr() {
        return this.or;
    }

    public void setOr(Collection<Expression> or) {
        if (or == null) {
            this.or = null;
            return;
        }
        this.or = new ArrayList<Expression>(or);
    }

    public Expression withOr(Expression ... or) {
        if (this.or == null) {
            this.setOr(new ArrayList<Expression>(or.length));
        }
        for (Expression ele : or) {
            this.or.add(ele);
        }
        return this;
    }

    public Expression withOr(Collection<Expression> or) {
        this.setOr(or);
        return this;
    }

    public List<Expression> getAnd() {
        return this.and;
    }

    public void setAnd(Collection<Expression> and) {
        if (and == null) {
            this.and = null;
            return;
        }
        this.and = new ArrayList<Expression>(and);
    }

    public Expression withAnd(Expression ... and) {
        if (this.and == null) {
            this.setAnd(new ArrayList<Expression>(and.length));
        }
        for (Expression ele : and) {
            this.and.add(ele);
        }
        return this;
    }

    public Expression withAnd(Collection<Expression> and) {
        this.setAnd(and);
        return this;
    }

    public void setNot(Expression not) {
        this.not = not;
    }

    public Expression getNot() {
        return this.not;
    }

    public Expression withNot(Expression not) {
        this.setNot(not);
        return this;
    }

    public void setDimensions(DimensionValues dimensions) {
        this.dimensions = dimensions;
    }

    public DimensionValues getDimensions() {
        return this.dimensions;
    }

    public Expression withDimensions(DimensionValues dimensions) {
        this.setDimensions(dimensions);
        return this;
    }

    public void setTags(TagValues tags) {
        this.tags = tags;
    }

    public TagValues getTags() {
        return this.tags;
    }

    public Expression withTags(TagValues tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOr() != null) {
            sb.append("Or: ").append(this.getOr()).append(",");
        }
        if (this.getAnd() != null) {
            sb.append("And: ").append(this.getAnd()).append(",");
        }
        if (this.getNot() != null) {
            sb.append("Not: ").append(this.getNot()).append(",");
        }
        if (this.getDimensions() != null) {
            sb.append("Dimensions: ").append(this.getDimensions()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Expression)) {
            return false;
        }
        Expression other = (Expression)obj;
        if (other.getOr() == null ^ this.getOr() == null) {
            return false;
        }
        if (other.getOr() != null && !other.getOr().equals(this.getOr())) {
            return false;
        }
        if (other.getAnd() == null ^ this.getAnd() == null) {
            return false;
        }
        if (other.getAnd() != null && !other.getAnd().equals(this.getAnd())) {
            return false;
        }
        if (other.getNot() == null ^ this.getNot() == null) {
            return false;
        }
        if (other.getNot() != null && !other.getNot().equals(this.getNot())) {
            return false;
        }
        if (other.getDimensions() == null ^ this.getDimensions() == null) {
            return false;
        }
        if (other.getDimensions() != null && !other.getDimensions().equals(this.getDimensions())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOr() == null ? 0 : this.getOr().hashCode());
        hashCode = 31 * hashCode + (this.getAnd() == null ? 0 : this.getAnd().hashCode());
        hashCode = 31 * hashCode + (this.getNot() == null ? 0 : this.getNot().hashCode());
        hashCode = 31 * hashCode + (this.getDimensions() == null ? 0 : this.getDimensions().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public Expression clone() {
        try {
            return (Expression)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExpressionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

