/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.codecommit.model.Target;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreatePullRequestRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String title;
    private String description;
    private List<Target> targets;
    private String clientRequestToken;

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public CreatePullRequestRequest withTitle(String title) {
        this.setTitle(title);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreatePullRequestRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<Target> getTargets() {
        return this.targets;
    }

    public void setTargets(Collection<Target> targets) {
        if (targets == null) {
            this.targets = null;
            return;
        }
        this.targets = new ArrayList<Target>(targets);
    }

    public CreatePullRequestRequest withTargets(Target ... targets) {
        if (this.targets == null) {
            this.setTargets(new ArrayList<Target>(targets.length));
        }
        for (Target ele : targets) {
            this.targets.add(ele);
        }
        return this;
    }

    public CreatePullRequestRequest withTargets(Collection<Target> targets) {
        this.setTargets(targets);
        return this;
    }

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public CreatePullRequestRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTitle() != null) {
            sb.append("Title: ").append(this.getTitle()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getTargets() != null) {
            sb.append("Targets: ").append(this.getTargets()).append(",");
        }
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePullRequestRequest)) {
            return false;
        }
        CreatePullRequestRequest other = (CreatePullRequestRequest)obj;
        if (other.getTitle() == null ^ this.getTitle() == null) {
            return false;
        }
        if (other.getTitle() != null && !other.getTitle().equals(this.getTitle())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        if (other.getTargets() != null && !other.getTargets().equals(this.getTargets())) {
            return false;
        }
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        return other.getClientRequestToken() == null || other.getClientRequestToken().equals(this.getClientRequestToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTitle() == null ? 0 : this.getTitle().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        return hashCode;
    }

    @Override
    public CreatePullRequestRequest clone() {
        return (CreatePullRequestRequest)super.clone();
    }
}

