/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.shield;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.shield.AWSShieldAsync;
import com.amazonaws.services.shield.AWSShieldAsyncClientBuilder;
import com.amazonaws.services.shield.AWSShieldClient;
import com.amazonaws.services.shield.model.CreateProtectionRequest;
import com.amazonaws.services.shield.model.CreateProtectionResult;
import com.amazonaws.services.shield.model.CreateSubscriptionRequest;
import com.amazonaws.services.shield.model.CreateSubscriptionResult;
import com.amazonaws.services.shield.model.DeleteProtectionRequest;
import com.amazonaws.services.shield.model.DeleteProtectionResult;
import com.amazonaws.services.shield.model.DeleteSubscriptionRequest;
import com.amazonaws.services.shield.model.DeleteSubscriptionResult;
import com.amazonaws.services.shield.model.DescribeAttackRequest;
import com.amazonaws.services.shield.model.DescribeAttackResult;
import com.amazonaws.services.shield.model.DescribeProtectionRequest;
import com.amazonaws.services.shield.model.DescribeProtectionResult;
import com.amazonaws.services.shield.model.DescribeSubscriptionRequest;
import com.amazonaws.services.shield.model.DescribeSubscriptionResult;
import com.amazonaws.services.shield.model.GetSubscriptionStateRequest;
import com.amazonaws.services.shield.model.GetSubscriptionStateResult;
import com.amazonaws.services.shield.model.ListAttacksRequest;
import com.amazonaws.services.shield.model.ListAttacksResult;
import com.amazonaws.services.shield.model.ListProtectionsRequest;
import com.amazonaws.services.shield.model.ListProtectionsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSShieldAsyncClient
extends AWSShieldClient
implements AWSShieldAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AWSShieldAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AWSShieldAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSShieldAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSShieldAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSShieldAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AWSShieldAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSShieldAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSShieldAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSShieldAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AWSShieldAsyncClientBuilder asyncBuilder() {
        return AWSShieldAsyncClientBuilder.standard();
    }

    AWSShieldAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateProtectionResult> createProtectionAsync(CreateProtectionRequest request) {
        return this.createProtectionAsync(request, null);
    }

    @Override
    public Future<CreateProtectionResult> createProtectionAsync(CreateProtectionRequest request, final AsyncHandler<CreateProtectionRequest, CreateProtectionResult> asyncHandler) {
        final CreateProtectionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateProtectionResult>(){

            @Override
            public CreateProtectionResult call() throws Exception {
                CreateProtectionResult result = null;
                try {
                    result = AWSShieldAsyncClient.this.executeCreateProtection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSubscriptionResult> createSubscriptionAsync(CreateSubscriptionRequest request) {
        return this.createSubscriptionAsync(request, null);
    }

    @Override
    public Future<CreateSubscriptionResult> createSubscriptionAsync(CreateSubscriptionRequest request, final AsyncHandler<CreateSubscriptionRequest, CreateSubscriptionResult> asyncHandler) {
        final CreateSubscriptionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSubscriptionResult>(){

            @Override
            public CreateSubscriptionResult call() throws Exception {
                CreateSubscriptionResult result = null;
                try {
                    result = AWSShieldAsyncClient.this.executeCreateSubscription(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteProtectionResult> deleteProtectionAsync(DeleteProtectionRequest request) {
        return this.deleteProtectionAsync(request, null);
    }

    @Override
    public Future<DeleteProtectionResult> deleteProtectionAsync(DeleteProtectionRequest request, final AsyncHandler<DeleteProtectionRequest, DeleteProtectionResult> asyncHandler) {
        final DeleteProtectionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteProtectionResult>(){

            @Override
            public DeleteProtectionResult call() throws Exception {
                DeleteProtectionResult result = null;
                try {
                    result = AWSShieldAsyncClient.this.executeDeleteProtection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSubscriptionResult> deleteSubscriptionAsync(DeleteSubscriptionRequest request) {
        return this.deleteSubscriptionAsync(request, null);
    }

    @Override
    public Future<DeleteSubscriptionResult> deleteSubscriptionAsync(DeleteSubscriptionRequest request, final AsyncHandler<DeleteSubscriptionRequest, DeleteSubscriptionResult> asyncHandler) {
        final DeleteSubscriptionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSubscriptionResult>(){

            @Override
            public DeleteSubscriptionResult call() throws Exception {
                DeleteSubscriptionResult result = null;
                try {
                    result = AWSShieldAsyncClient.this.executeDeleteSubscription(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAttackResult> describeAttackAsync(DescribeAttackRequest request) {
        return this.describeAttackAsync(request, null);
    }

    @Override
    public Future<DescribeAttackResult> describeAttackAsync(DescribeAttackRequest request, final AsyncHandler<DescribeAttackRequest, DescribeAttackResult> asyncHandler) {
        final DescribeAttackRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAttackResult>(){

            @Override
            public DescribeAttackResult call() throws Exception {
                DescribeAttackResult result = null;
                try {
                    result = AWSShieldAsyncClient.this.executeDescribeAttack(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeProtectionResult> describeProtectionAsync(DescribeProtectionRequest request) {
        return this.describeProtectionAsync(request, null);
    }

    @Override
    public Future<DescribeProtectionResult> describeProtectionAsync(DescribeProtectionRequest request, final AsyncHandler<DescribeProtectionRequest, DescribeProtectionResult> asyncHandler) {
        final DescribeProtectionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeProtectionResult>(){

            @Override
            public DescribeProtectionResult call() throws Exception {
                DescribeProtectionResult result = null;
                try {
                    result = AWSShieldAsyncClient.this.executeDescribeProtection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSubscriptionResult> describeSubscriptionAsync(DescribeSubscriptionRequest request) {
        return this.describeSubscriptionAsync(request, null);
    }

    @Override
    public Future<DescribeSubscriptionResult> describeSubscriptionAsync(DescribeSubscriptionRequest request, final AsyncHandler<DescribeSubscriptionRequest, DescribeSubscriptionResult> asyncHandler) {
        final DescribeSubscriptionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeSubscriptionResult>(){

            @Override
            public DescribeSubscriptionResult call() throws Exception {
                DescribeSubscriptionResult result = null;
                try {
                    result = AWSShieldAsyncClient.this.executeDescribeSubscription(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSubscriptionStateResult> getSubscriptionStateAsync(GetSubscriptionStateRequest request) {
        return this.getSubscriptionStateAsync(request, null);
    }

    @Override
    public Future<GetSubscriptionStateResult> getSubscriptionStateAsync(GetSubscriptionStateRequest request, final AsyncHandler<GetSubscriptionStateRequest, GetSubscriptionStateResult> asyncHandler) {
        final GetSubscriptionStateRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSubscriptionStateResult>(){

            @Override
            public GetSubscriptionStateResult call() throws Exception {
                GetSubscriptionStateResult result = null;
                try {
                    result = AWSShieldAsyncClient.this.executeGetSubscriptionState(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAttacksResult> listAttacksAsync(ListAttacksRequest request) {
        return this.listAttacksAsync(request, null);
    }

    @Override
    public Future<ListAttacksResult> listAttacksAsync(ListAttacksRequest request, final AsyncHandler<ListAttacksRequest, ListAttacksResult> asyncHandler) {
        final ListAttacksRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAttacksResult>(){

            @Override
            public ListAttacksResult call() throws Exception {
                ListAttacksResult result = null;
                try {
                    result = AWSShieldAsyncClient.this.executeListAttacks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListProtectionsResult> listProtectionsAsync(ListProtectionsRequest request) {
        return this.listProtectionsAsync(request, null);
    }

    @Override
    public Future<ListProtectionsResult> listProtectionsAsync(ListProtectionsRequest request, final AsyncHandler<ListProtectionsRequest, ListProtectionsResult> asyncHandler) {
        final ListProtectionsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListProtectionsResult>(){

            @Override
            public ListProtectionsResult call() throws Exception {
                ListProtectionsResult result = null;
                try {
                    result = AWSShieldAsyncClient.this.executeListProtections(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

