/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.TimecodeConfig;

@SdkInternalApi
public class TimecodeConfigMarshaller {
    private static final MarshallingInfo<String> ANCHOR_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("anchor").build();
    private static final MarshallingInfo<String> SOURCE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("source").build();
    private static final MarshallingInfo<String> START_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("start").build();
    private static final MarshallingInfo<String> TIMESTAMPOFFSET_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timestampOffset").build();
    private static final TimecodeConfigMarshaller instance = new TimecodeConfigMarshaller();

    public static TimecodeConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(TimecodeConfig timecodeConfig, ProtocolMarshaller protocolMarshaller) {
        if (timecodeConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(timecodeConfig.getAnchor(), ANCHOR_BINDING);
            protocolMarshaller.marshall(timecodeConfig.getSource(), SOURCE_BINDING);
            protocolMarshaller.marshall(timecodeConfig.getStart(), START_BINDING);
            protocolMarshaller.marshall(timecodeConfig.getTimestampOffset(), TIMESTAMPOFFSET_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

