/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.lightsail.model.DiskMap;

@SdkInternalApi
public class DiskMapMarshaller {
    private static final MarshallingInfo<String> ORIGINALDISKPATH_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("originalDiskPath").build();
    private static final MarshallingInfo<String> NEWDISKNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("newDiskName").build();
    private static final DiskMapMarshaller instance = new DiskMapMarshaller();

    public static DiskMapMarshaller getInstance() {
        return instance;
    }

    public void marshall(DiskMap diskMap, ProtocolMarshaller protocolMarshaller) {
        if (diskMap == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(diskMap.getOriginalDiskPath(), ORIGINALDISKPATH_BINDING);
            protocolMarshaller.marshall(diskMap.getNewDiskName(), NEWDISKNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

