/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glacier.model.InventoryRetrievalJobInput;
import com.amazonaws.services.glacier.model.OutputLocation;
import com.amazonaws.services.glacier.model.SelectParameters;
import com.amazonaws.services.glacier.model.transform.JobParametersMarshaller;
import java.io.Serializable;

public class JobParameters
implements Serializable,
Cloneable,
StructuredPojo {
    private String format;
    private String type;
    private String archiveId;
    private String description;
    private String sNSTopic;
    private String retrievalByteRange;
    private String tier;
    private InventoryRetrievalJobInput inventoryRetrievalParameters;
    private SelectParameters selectParameters;
    private OutputLocation outputLocation;

    public JobParameters() {
    }

    public JobParameters(String format, String type, String archiveId, String description) {
        this.setFormat(format);
        this.setType(type);
        this.setArchiveId(archiveId);
        this.setDescription(description);
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public JobParameters withFormat(String format) {
        this.setFormat(format);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public JobParameters withType(String type) {
        this.setType(type);
        return this;
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

    public String getArchiveId() {
        return this.archiveId;
    }

    public JobParameters withArchiveId(String archiveId) {
        this.setArchiveId(archiveId);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public JobParameters withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setSNSTopic(String sNSTopic) {
        this.sNSTopic = sNSTopic;
    }

    public String getSNSTopic() {
        return this.sNSTopic;
    }

    public JobParameters withSNSTopic(String sNSTopic) {
        this.setSNSTopic(sNSTopic);
        return this;
    }

    public void setRetrievalByteRange(String retrievalByteRange) {
        this.retrievalByteRange = retrievalByteRange;
    }

    public String getRetrievalByteRange() {
        return this.retrievalByteRange;
    }

    public JobParameters withRetrievalByteRange(String retrievalByteRange) {
        this.setRetrievalByteRange(retrievalByteRange);
        return this;
    }

    public void setTier(String tier) {
        this.tier = tier;
    }

    public String getTier() {
        return this.tier;
    }

    public JobParameters withTier(String tier) {
        this.setTier(tier);
        return this;
    }

    public void setInventoryRetrievalParameters(InventoryRetrievalJobInput inventoryRetrievalParameters) {
        this.inventoryRetrievalParameters = inventoryRetrievalParameters;
    }

    public InventoryRetrievalJobInput getInventoryRetrievalParameters() {
        return this.inventoryRetrievalParameters;
    }

    public JobParameters withInventoryRetrievalParameters(InventoryRetrievalJobInput inventoryRetrievalParameters) {
        this.setInventoryRetrievalParameters(inventoryRetrievalParameters);
        return this;
    }

    public void setSelectParameters(SelectParameters selectParameters) {
        this.selectParameters = selectParameters;
    }

    public SelectParameters getSelectParameters() {
        return this.selectParameters;
    }

    public JobParameters withSelectParameters(SelectParameters selectParameters) {
        this.setSelectParameters(selectParameters);
        return this;
    }

    public void setOutputLocation(OutputLocation outputLocation) {
        this.outputLocation = outputLocation;
    }

    public OutputLocation getOutputLocation() {
        return this.outputLocation;
    }

    public JobParameters withOutputLocation(OutputLocation outputLocation) {
        this.setOutputLocation(outputLocation);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFormat() != null) {
            sb.append("Format: ").append(this.getFormat()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getArchiveId() != null) {
            sb.append("ArchiveId: ").append(this.getArchiveId()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getSNSTopic() != null) {
            sb.append("SNSTopic: ").append(this.getSNSTopic()).append(",");
        }
        if (this.getRetrievalByteRange() != null) {
            sb.append("RetrievalByteRange: ").append(this.getRetrievalByteRange()).append(",");
        }
        if (this.getTier() != null) {
            sb.append("Tier: ").append(this.getTier()).append(",");
        }
        if (this.getInventoryRetrievalParameters() != null) {
            sb.append("InventoryRetrievalParameters: ").append(this.getInventoryRetrievalParameters()).append(",");
        }
        if (this.getSelectParameters() != null) {
            sb.append("SelectParameters: ").append(this.getSelectParameters()).append(",");
        }
        if (this.getOutputLocation() != null) {
            sb.append("OutputLocation: ").append(this.getOutputLocation());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobParameters)) {
            return false;
        }
        JobParameters other = (JobParameters)obj;
        if (other.getFormat() == null ^ this.getFormat() == null) {
            return false;
        }
        if (other.getFormat() != null && !other.getFormat().equals(this.getFormat())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getArchiveId() == null ^ this.getArchiveId() == null) {
            return false;
        }
        if (other.getArchiveId() != null && !other.getArchiveId().equals(this.getArchiveId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getSNSTopic() == null ^ this.getSNSTopic() == null) {
            return false;
        }
        if (other.getSNSTopic() != null && !other.getSNSTopic().equals(this.getSNSTopic())) {
            return false;
        }
        if (other.getRetrievalByteRange() == null ^ this.getRetrievalByteRange() == null) {
            return false;
        }
        if (other.getRetrievalByteRange() != null && !other.getRetrievalByteRange().equals(this.getRetrievalByteRange())) {
            return false;
        }
        if (other.getTier() == null ^ this.getTier() == null) {
            return false;
        }
        if (other.getTier() != null && !other.getTier().equals(this.getTier())) {
            return false;
        }
        if (other.getInventoryRetrievalParameters() == null ^ this.getInventoryRetrievalParameters() == null) {
            return false;
        }
        if (other.getInventoryRetrievalParameters() != null && !other.getInventoryRetrievalParameters().equals(this.getInventoryRetrievalParameters())) {
            return false;
        }
        if (other.getSelectParameters() == null ^ this.getSelectParameters() == null) {
            return false;
        }
        if (other.getSelectParameters() != null && !other.getSelectParameters().equals(this.getSelectParameters())) {
            return false;
        }
        if (other.getOutputLocation() == null ^ this.getOutputLocation() == null) {
            return false;
        }
        return other.getOutputLocation() == null || other.getOutputLocation().equals(this.getOutputLocation());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFormat() == null ? 0 : this.getFormat().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getArchiveId() == null ? 0 : this.getArchiveId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getSNSTopic() == null ? 0 : this.getSNSTopic().hashCode());
        hashCode = 31 * hashCode + (this.getRetrievalByteRange() == null ? 0 : this.getRetrievalByteRange().hashCode());
        hashCode = 31 * hashCode + (this.getTier() == null ? 0 : this.getTier().hashCode());
        hashCode = 31 * hashCode + (this.getInventoryRetrievalParameters() == null ? 0 : this.getInventoryRetrievalParameters().hashCode());
        hashCode = 31 * hashCode + (this.getSelectParameters() == null ? 0 : this.getSelectParameters().hashCode());
        hashCode = 31 * hashCode + (this.getOutputLocation() == null ? 0 : this.getOutputLocation().hashCode());
        return hashCode;
    }

    public JobParameters clone() {
        try {
            return (JobParameters)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

