/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.ecr.AmazonECR;
import com.amazonaws.services.ecr.AmazonECRClientBuilder;
import com.amazonaws.services.ecr.model.AmazonECRException;
import com.amazonaws.services.ecr.model.BatchCheckLayerAvailabilityRequest;
import com.amazonaws.services.ecr.model.BatchCheckLayerAvailabilityResult;
import com.amazonaws.services.ecr.model.BatchDeleteImageRequest;
import com.amazonaws.services.ecr.model.BatchDeleteImageResult;
import com.amazonaws.services.ecr.model.BatchGetImageRequest;
import com.amazonaws.services.ecr.model.BatchGetImageResult;
import com.amazonaws.services.ecr.model.CompleteLayerUploadRequest;
import com.amazonaws.services.ecr.model.CompleteLayerUploadResult;
import com.amazonaws.services.ecr.model.CreateRepositoryRequest;
import com.amazonaws.services.ecr.model.CreateRepositoryResult;
import com.amazonaws.services.ecr.model.DeleteLifecyclePolicyRequest;
import com.amazonaws.services.ecr.model.DeleteLifecyclePolicyResult;
import com.amazonaws.services.ecr.model.DeleteRepositoryPolicyRequest;
import com.amazonaws.services.ecr.model.DeleteRepositoryPolicyResult;
import com.amazonaws.services.ecr.model.DeleteRepositoryRequest;
import com.amazonaws.services.ecr.model.DeleteRepositoryResult;
import com.amazonaws.services.ecr.model.DescribeImagesRequest;
import com.amazonaws.services.ecr.model.DescribeImagesResult;
import com.amazonaws.services.ecr.model.DescribeRepositoriesRequest;
import com.amazonaws.services.ecr.model.DescribeRepositoriesResult;
import com.amazonaws.services.ecr.model.EmptyUploadException;
import com.amazonaws.services.ecr.model.GetAuthorizationTokenRequest;
import com.amazonaws.services.ecr.model.GetAuthorizationTokenResult;
import com.amazonaws.services.ecr.model.GetDownloadUrlForLayerRequest;
import com.amazonaws.services.ecr.model.GetDownloadUrlForLayerResult;
import com.amazonaws.services.ecr.model.GetLifecyclePolicyPreviewRequest;
import com.amazonaws.services.ecr.model.GetLifecyclePolicyPreviewResult;
import com.amazonaws.services.ecr.model.GetLifecyclePolicyRequest;
import com.amazonaws.services.ecr.model.GetLifecyclePolicyResult;
import com.amazonaws.services.ecr.model.GetRepositoryPolicyRequest;
import com.amazonaws.services.ecr.model.GetRepositoryPolicyResult;
import com.amazonaws.services.ecr.model.ImageAlreadyExistsException;
import com.amazonaws.services.ecr.model.ImageNotFoundException;
import com.amazonaws.services.ecr.model.InitiateLayerUploadRequest;
import com.amazonaws.services.ecr.model.InitiateLayerUploadResult;
import com.amazonaws.services.ecr.model.InvalidLayerException;
import com.amazonaws.services.ecr.model.InvalidLayerPartException;
import com.amazonaws.services.ecr.model.InvalidParameterException;
import com.amazonaws.services.ecr.model.LayerAlreadyExistsException;
import com.amazonaws.services.ecr.model.LayerInaccessibleException;
import com.amazonaws.services.ecr.model.LayerPartTooSmallException;
import com.amazonaws.services.ecr.model.LayersNotFoundException;
import com.amazonaws.services.ecr.model.LifecyclePolicyNotFoundException;
import com.amazonaws.services.ecr.model.LifecyclePolicyPreviewInProgressException;
import com.amazonaws.services.ecr.model.LifecyclePolicyPreviewNotFoundException;
import com.amazonaws.services.ecr.model.LimitExceededException;
import com.amazonaws.services.ecr.model.ListImagesRequest;
import com.amazonaws.services.ecr.model.ListImagesResult;
import com.amazonaws.services.ecr.model.PutImageRequest;
import com.amazonaws.services.ecr.model.PutImageResult;
import com.amazonaws.services.ecr.model.PutLifecyclePolicyRequest;
import com.amazonaws.services.ecr.model.PutLifecyclePolicyResult;
import com.amazonaws.services.ecr.model.RepositoryAlreadyExistsException;
import com.amazonaws.services.ecr.model.RepositoryNotEmptyException;
import com.amazonaws.services.ecr.model.RepositoryNotFoundException;
import com.amazonaws.services.ecr.model.RepositoryPolicyNotFoundException;
import com.amazonaws.services.ecr.model.ServerException;
import com.amazonaws.services.ecr.model.SetRepositoryPolicyRequest;
import com.amazonaws.services.ecr.model.SetRepositoryPolicyResult;
import com.amazonaws.services.ecr.model.StartLifecyclePolicyPreviewRequest;
import com.amazonaws.services.ecr.model.StartLifecyclePolicyPreviewResult;
import com.amazonaws.services.ecr.model.UploadLayerPartRequest;
import com.amazonaws.services.ecr.model.UploadLayerPartResult;
import com.amazonaws.services.ecr.model.UploadNotFoundException;
import com.amazonaws.services.ecr.model.transform.BatchCheckLayerAvailabilityRequestProtocolMarshaller;
import com.amazonaws.services.ecr.model.transform.BatchCheckLayerAvailabilityResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.BatchDeleteImageRequestProtocolMarshaller;
import com.amazonaws.services.ecr.model.transform.BatchDeleteImageResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.BatchGetImageRequestProtocolMarshaller;
import com.amazonaws.services.ecr.model.transform.BatchGetImageResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.CompleteLayerUploadRequestProtocolMarshaller;
import com.amazonaws.services.ecr.model.transform.CompleteLayerUploadResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.CreateRepositoryRequestProtocolMarshaller;
import com.amazonaws.services.ecr.model.transform.CreateRepositoryResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.DeleteLifecyclePolicyRequestProtocolMarshaller;
import com.amazonaws.services.ecr.model.transform.DeleteLifecyclePolicyResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.DeleteRepositoryPolicyRequestProtocolMarshaller;
import com.amazonaws.services.ecr.model.transform.DeleteRepositoryPolicyResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.DeleteRepositoryRequestProtocolMarshaller;
import com.amazonaws.services.ecr.model.transform.DeleteRepositoryResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.DescribeImagesRequestProtocolMarshaller;
import com.amazonaws.services.ecr.model.transform.DescribeImagesResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.DescribeRepositoriesRequestProtocolMarshaller;
import com.amazonaws.services.ecr.model.transform.DescribeRepositoriesResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.GetAuthorizationTokenRequestProtocolMarshaller;
import com.amazonaws.services.ecr.model.transform.GetAuthorizationTokenResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.GetDownloadUrlForLayerRequestProtocolMarshaller;
import com.amazonaws.services.ecr.model.transform.GetDownloadUrlForLayerResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.GetLifecyclePolicyPreviewRequestProtocolMarshaller;
import com.amazonaws.services.ecr.model.transform.GetLifecyclePolicyPreviewResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.GetLifecyclePolicyRequestProtocolMarshaller;
import com.amazonaws.services.ecr.model.transform.GetLifecyclePolicyResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.GetRepositoryPolicyRequestProtocolMarshaller;
import com.amazonaws.services.ecr.model.transform.GetRepositoryPolicyResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.InitiateLayerUploadRequestProtocolMarshaller;
import com.amazonaws.services.ecr.model.transform.InitiateLayerUploadResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.ListImagesRequestProtocolMarshaller;
import com.amazonaws.services.ecr.model.transform.ListImagesResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.PutImageRequestProtocolMarshaller;
import com.amazonaws.services.ecr.model.transform.PutImageResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.PutLifecyclePolicyRequestProtocolMarshaller;
import com.amazonaws.services.ecr.model.transform.PutLifecyclePolicyResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.SetRepositoryPolicyRequestProtocolMarshaller;
import com.amazonaws.services.ecr.model.transform.SetRepositoryPolicyResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.StartLifecyclePolicyPreviewRequestProtocolMarshaller;
import com.amazonaws.services.ecr.model.transform.StartLifecyclePolicyPreviewResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.UploadLayerPartRequestProtocolMarshaller;
import com.amazonaws.services.ecr.model.transform.UploadLayerPartResultJsonUnmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonECRClient
extends AmazonWebServiceClient
implements AmazonECR {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonECR.class);
    private static final String DEFAULT_SIGNING_NAME = "ecr";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LayerPartTooSmallException").withModeledClass(LayerPartTooSmallException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidLayerPartException").withModeledClass(InvalidLayerPartException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterException").withModeledClass(InvalidParameterException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LifecyclePolicyPreviewNotFoundException").withModeledClass(LifecyclePolicyPreviewNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServerException").withModeledClass(ServerException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RepositoryNotEmptyException").withModeledClass(RepositoryNotEmptyException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LifecyclePolicyNotFoundException").withModeledClass(LifecyclePolicyNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LayerAlreadyExistsException").withModeledClass(LayerAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("EmptyUploadException").withModeledClass(EmptyUploadException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ImageNotFoundException").withModeledClass(ImageNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LayersNotFoundException").withModeledClass(LayersNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidLayerException").withModeledClass(InvalidLayerException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RepositoryNotFoundException").withModeledClass(RepositoryNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RepositoryAlreadyExistsException").withModeledClass(RepositoryAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RepositoryPolicyNotFoundException").withModeledClass(RepositoryPolicyNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LifecyclePolicyPreviewInProgressException").withModeledClass(LifecyclePolicyPreviewInProgressException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ImageAlreadyExistsException").withModeledClass(ImageAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LayerInaccessibleException").withModeledClass(LayerInaccessibleException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UploadNotFoundException").withModeledClass(UploadNotFoundException.class)).withBaseServiceExceptionClass(AmazonECRException.class));

    @Deprecated
    public AmazonECRClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AmazonECRClient(ClientConfiguration clientConfiguration) {
        this(DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AmazonECRClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AmazonECRClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    @Deprecated
    public AmazonECRClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AmazonECRClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AmazonECRClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    public static AmazonECRClientBuilder builder() {
        return AmazonECRClientBuilder.standard();
    }

    AmazonECRClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("ecr.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/ecr/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/ecr/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BatchCheckLayerAvailabilityResult batchCheckLayerAvailability(BatchCheckLayerAvailabilityRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeBatchCheckLayerAvailability(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchCheckLayerAvailabilityResult executeBatchCheckLayerAvailability(BatchCheckLayerAvailabilityRequest batchCheckLayerAvailabilityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchCheckLayerAvailabilityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchCheckLayerAvailabilityRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchCheckLayerAvailabilityRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(batchCheckLayerAvailabilityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new BatchCheckLayerAvailabilityResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchCheckLayerAvailabilityResult batchCheckLayerAvailabilityResult = (BatchCheckLayerAvailabilityResult)response.getAwsResponse();
            return batchCheckLayerAvailabilityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchDeleteImageResult batchDeleteImage(BatchDeleteImageRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeBatchDeleteImage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchDeleteImageResult executeBatchDeleteImage(BatchDeleteImageRequest batchDeleteImageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchDeleteImageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchDeleteImageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchDeleteImageRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(batchDeleteImageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new BatchDeleteImageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchDeleteImageResult batchDeleteImageResult = (BatchDeleteImageResult)response.getAwsResponse();
            return batchDeleteImageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchGetImageResult batchGetImage(BatchGetImageRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeBatchGetImage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchGetImageResult executeBatchGetImage(BatchGetImageRequest batchGetImageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchGetImageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchGetImageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchGetImageRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(batchGetImageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new BatchGetImageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchGetImageResult batchGetImageResult = (BatchGetImageResult)response.getAwsResponse();
            return batchGetImageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CompleteLayerUploadResult completeLayerUpload(CompleteLayerUploadRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCompleteLayerUpload(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CompleteLayerUploadResult executeCompleteLayerUpload(CompleteLayerUploadRequest completeLayerUploadRequest) {
        ExecutionContext executionContext = this.createExecutionContext(completeLayerUploadRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CompleteLayerUploadRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CompleteLayerUploadRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(completeLayerUploadRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CompleteLayerUploadResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CompleteLayerUploadResult completeLayerUploadResult = (CompleteLayerUploadResult)response.getAwsResponse();
            return completeLayerUploadResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateRepositoryResult createRepository(CreateRepositoryRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeCreateRepository(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateRepositoryResult executeCreateRepository(CreateRepositoryRequest createRepositoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createRepositoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateRepositoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateRepositoryRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(createRepositoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateRepositoryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateRepositoryResult createRepositoryResult = (CreateRepositoryResult)response.getAwsResponse();
            return createRepositoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteLifecyclePolicyResult deleteLifecyclePolicy(DeleteLifecyclePolicyRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteLifecyclePolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteLifecyclePolicyResult executeDeleteLifecyclePolicy(DeleteLifecyclePolicyRequest deleteLifecyclePolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteLifecyclePolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteLifecyclePolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteLifecyclePolicyRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteLifecyclePolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteLifecyclePolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteLifecyclePolicyResult deleteLifecyclePolicyResult = (DeleteLifecyclePolicyResult)response.getAwsResponse();
            return deleteLifecyclePolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteRepositoryResult deleteRepository(DeleteRepositoryRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteRepository(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteRepositoryResult executeDeleteRepository(DeleteRepositoryRequest deleteRepositoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteRepositoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteRepositoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteRepositoryRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteRepositoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteRepositoryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteRepositoryResult deleteRepositoryResult = (DeleteRepositoryResult)response.getAwsResponse();
            return deleteRepositoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteRepositoryPolicyResult deleteRepositoryPolicy(DeleteRepositoryPolicyRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteRepositoryPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteRepositoryPolicyResult executeDeleteRepositoryPolicy(DeleteRepositoryPolicyRequest deleteRepositoryPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteRepositoryPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteRepositoryPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteRepositoryPolicyRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(deleteRepositoryPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteRepositoryPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteRepositoryPolicyResult deleteRepositoryPolicyResult = (DeleteRepositoryPolicyResult)response.getAwsResponse();
            return deleteRepositoryPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeImagesResult describeImages(DescribeImagesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeImages(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeImagesResult executeDescribeImages(DescribeImagesRequest describeImagesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeImagesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeImagesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeImagesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeImagesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeImagesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeImagesResult describeImagesResult = (DescribeImagesResult)response.getAwsResponse();
            return describeImagesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeRepositoriesResult describeRepositories(DescribeRepositoriesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeRepositories(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeRepositoriesResult executeDescribeRepositories(DescribeRepositoriesRequest describeRepositoriesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeRepositoriesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeRepositoriesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeRepositoriesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(describeRepositoriesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeRepositoriesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeRepositoriesResult describeRepositoriesResult = (DescribeRepositoriesResult)response.getAwsResponse();
            return describeRepositoriesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAuthorizationTokenResult getAuthorizationToken(GetAuthorizationTokenRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetAuthorizationToken(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAuthorizationTokenResult executeGetAuthorizationToken(GetAuthorizationTokenRequest getAuthorizationTokenRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAuthorizationTokenRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAuthorizationTokenRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAuthorizationTokenRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getAuthorizationTokenRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetAuthorizationTokenResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetAuthorizationTokenResult getAuthorizationTokenResult = (GetAuthorizationTokenResult)response.getAwsResponse();
            return getAuthorizationTokenResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDownloadUrlForLayerResult getDownloadUrlForLayer(GetDownloadUrlForLayerRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetDownloadUrlForLayer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDownloadUrlForLayerResult executeGetDownloadUrlForLayer(GetDownloadUrlForLayerRequest getDownloadUrlForLayerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDownloadUrlForLayerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDownloadUrlForLayerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDownloadUrlForLayerRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getDownloadUrlForLayerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetDownloadUrlForLayerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDownloadUrlForLayerResult getDownloadUrlForLayerResult = (GetDownloadUrlForLayerResult)response.getAwsResponse();
            return getDownloadUrlForLayerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetLifecyclePolicyResult getLifecyclePolicy(GetLifecyclePolicyRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetLifecyclePolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetLifecyclePolicyResult executeGetLifecyclePolicy(GetLifecyclePolicyRequest getLifecyclePolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getLifecyclePolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetLifecyclePolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetLifecyclePolicyRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getLifecyclePolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetLifecyclePolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetLifecyclePolicyResult getLifecyclePolicyResult = (GetLifecyclePolicyResult)response.getAwsResponse();
            return getLifecyclePolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetLifecyclePolicyPreviewResult getLifecyclePolicyPreview(GetLifecyclePolicyPreviewRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetLifecyclePolicyPreview(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetLifecyclePolicyPreviewResult executeGetLifecyclePolicyPreview(GetLifecyclePolicyPreviewRequest getLifecyclePolicyPreviewRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getLifecyclePolicyPreviewRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetLifecyclePolicyPreviewRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetLifecyclePolicyPreviewRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getLifecyclePolicyPreviewRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetLifecyclePolicyPreviewResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetLifecyclePolicyPreviewResult getLifecyclePolicyPreviewResult = (GetLifecyclePolicyPreviewResult)response.getAwsResponse();
            return getLifecyclePolicyPreviewResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetRepositoryPolicyResult getRepositoryPolicy(GetRepositoryPolicyRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetRepositoryPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetRepositoryPolicyResult executeGetRepositoryPolicy(GetRepositoryPolicyRequest getRepositoryPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRepositoryPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRepositoryPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRepositoryPolicyRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getRepositoryPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetRepositoryPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetRepositoryPolicyResult getRepositoryPolicyResult = (GetRepositoryPolicyResult)response.getAwsResponse();
            return getRepositoryPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public InitiateLayerUploadResult initiateLayerUpload(InitiateLayerUploadRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeInitiateLayerUpload(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final InitiateLayerUploadResult executeInitiateLayerUpload(InitiateLayerUploadRequest initiateLayerUploadRequest) {
        ExecutionContext executionContext = this.createExecutionContext(initiateLayerUploadRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<InitiateLayerUploadRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new InitiateLayerUploadRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(initiateLayerUploadRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new InitiateLayerUploadResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            InitiateLayerUploadResult initiateLayerUploadResult = (InitiateLayerUploadResult)response.getAwsResponse();
            return initiateLayerUploadResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListImagesResult listImages(ListImagesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListImages(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListImagesResult executeListImages(ListImagesRequest listImagesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listImagesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListImagesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListImagesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(listImagesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListImagesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListImagesResult listImagesResult = (ListImagesResult)response.getAwsResponse();
            return listImagesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutImageResult putImage(PutImageRequest request) {
        request = this.beforeClientExecution(request);
        return this.executePutImage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutImageResult executePutImage(PutImageRequest putImageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putImageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutImageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutImageRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(putImageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new PutImageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutImageResult putImageResult = (PutImageResult)response.getAwsResponse();
            return putImageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutLifecyclePolicyResult putLifecyclePolicy(PutLifecyclePolicyRequest request) {
        request = this.beforeClientExecution(request);
        return this.executePutLifecyclePolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutLifecyclePolicyResult executePutLifecyclePolicy(PutLifecyclePolicyRequest putLifecyclePolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putLifecyclePolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutLifecyclePolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutLifecyclePolicyRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(putLifecyclePolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new PutLifecyclePolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutLifecyclePolicyResult putLifecyclePolicyResult = (PutLifecyclePolicyResult)response.getAwsResponse();
            return putLifecyclePolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SetRepositoryPolicyResult setRepositoryPolicy(SetRepositoryPolicyRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeSetRepositoryPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SetRepositoryPolicyResult executeSetRepositoryPolicy(SetRepositoryPolicyRequest setRepositoryPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setRepositoryPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetRepositoryPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SetRepositoryPolicyRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(setRepositoryPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new SetRepositoryPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SetRepositoryPolicyResult setRepositoryPolicyResult = (SetRepositoryPolicyResult)response.getAwsResponse();
            return setRepositoryPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartLifecyclePolicyPreviewResult startLifecyclePolicyPreview(StartLifecyclePolicyPreviewRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeStartLifecyclePolicyPreview(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartLifecyclePolicyPreviewResult executeStartLifecyclePolicyPreview(StartLifecyclePolicyPreviewRequest startLifecyclePolicyPreviewRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startLifecyclePolicyPreviewRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartLifecyclePolicyPreviewRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartLifecyclePolicyPreviewRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(startLifecyclePolicyPreviewRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new StartLifecyclePolicyPreviewResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartLifecyclePolicyPreviewResult startLifecyclePolicyPreviewResult = (StartLifecyclePolicyPreviewResult)response.getAwsResponse();
            return startLifecyclePolicyPreviewResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UploadLayerPartResult uploadLayerPart(UploadLayerPartRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUploadLayerPart(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UploadLayerPartResult executeUploadLayerPart(UploadLayerPartRequest uploadLayerPartRequest) {
        ExecutionContext executionContext = this.createExecutionContext(uploadLayerPartRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UploadLayerPartRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UploadLayerPartRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(uploadLayerPartRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UploadLayerPartResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UploadLayerPartResult uploadLayerPartResult = (UploadLayerPartResult)response.getAwsResponse();
            return uploadLayerPartResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

