/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costexplorer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.costexplorer.model.ReservationAggregates;

@SdkInternalApi
public class ReservationAggregatesMarshaller {
    private static final MarshallingInfo<String> UTILIZATIONPERCENTAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UtilizationPercentage").build();
    private static final MarshallingInfo<String> PURCHASEDHOURS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PurchasedHours").build();
    private static final MarshallingInfo<String> TOTALACTUALHOURS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalActualHours").build();
    private static final MarshallingInfo<String> UNUSEDHOURS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UnusedHours").build();
    private static final ReservationAggregatesMarshaller instance = new ReservationAggregatesMarshaller();

    public static ReservationAggregatesMarshaller getInstance() {
        return instance;
    }

    public void marshall(ReservationAggregates reservationAggregates, ProtocolMarshaller protocolMarshaller) {
        if (reservationAggregates == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(reservationAggregates.getUtilizationPercentage(), UTILIZATIONPERCENTAGE_BINDING);
            protocolMarshaller.marshall(reservationAggregates.getPurchasedHours(), PURCHASEDHOURS_BINDING);
            protocolMarshaller.marshall(reservationAggregates.getTotalActualHours(), TOTALACTUALHOURS_BINDING);
            protocolMarshaller.marshall(reservationAggregates.getUnusedHours(), UNUSEDHOURS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

