/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.comprehend.AmazonComprehendAsync;
import com.amazonaws.services.comprehend.AmazonComprehendAsyncClientBuilder;
import com.amazonaws.services.comprehend.AmazonComprehendClient;
import com.amazonaws.services.comprehend.model.BatchDetectDominantLanguageRequest;
import com.amazonaws.services.comprehend.model.BatchDetectDominantLanguageResult;
import com.amazonaws.services.comprehend.model.BatchDetectEntitiesRequest;
import com.amazonaws.services.comprehend.model.BatchDetectEntitiesResult;
import com.amazonaws.services.comprehend.model.BatchDetectKeyPhrasesRequest;
import com.amazonaws.services.comprehend.model.BatchDetectKeyPhrasesResult;
import com.amazonaws.services.comprehend.model.BatchDetectSentimentRequest;
import com.amazonaws.services.comprehend.model.BatchDetectSentimentResult;
import com.amazonaws.services.comprehend.model.DescribeTopicsDetectionJobRequest;
import com.amazonaws.services.comprehend.model.DescribeTopicsDetectionJobResult;
import com.amazonaws.services.comprehend.model.DetectDominantLanguageRequest;
import com.amazonaws.services.comprehend.model.DetectDominantLanguageResult;
import com.amazonaws.services.comprehend.model.DetectEntitiesRequest;
import com.amazonaws.services.comprehend.model.DetectEntitiesResult;
import com.amazonaws.services.comprehend.model.DetectKeyPhrasesRequest;
import com.amazonaws.services.comprehend.model.DetectKeyPhrasesResult;
import com.amazonaws.services.comprehend.model.DetectSentimentRequest;
import com.amazonaws.services.comprehend.model.DetectSentimentResult;
import com.amazonaws.services.comprehend.model.ListTopicsDetectionJobsRequest;
import com.amazonaws.services.comprehend.model.ListTopicsDetectionJobsResult;
import com.amazonaws.services.comprehend.model.StartTopicsDetectionJobRequest;
import com.amazonaws.services.comprehend.model.StartTopicsDetectionJobResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonComprehendAsyncClient
extends AmazonComprehendClient
implements AmazonComprehendAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonComprehendAsyncClientBuilder asyncBuilder() {
        return AmazonComprehendAsyncClientBuilder.standard();
    }

    AmazonComprehendAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchDetectDominantLanguageResult> batchDetectDominantLanguageAsync(BatchDetectDominantLanguageRequest request) {
        return this.batchDetectDominantLanguageAsync(request, null);
    }

    @Override
    public Future<BatchDetectDominantLanguageResult> batchDetectDominantLanguageAsync(BatchDetectDominantLanguageRequest request, final AsyncHandler<BatchDetectDominantLanguageRequest, BatchDetectDominantLanguageResult> asyncHandler) {
        final BatchDetectDominantLanguageRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchDetectDominantLanguageResult>(){

            @Override
            public BatchDetectDominantLanguageResult call() throws Exception {
                BatchDetectDominantLanguageResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeBatchDetectDominantLanguage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchDetectEntitiesResult> batchDetectEntitiesAsync(BatchDetectEntitiesRequest request) {
        return this.batchDetectEntitiesAsync(request, null);
    }

    @Override
    public Future<BatchDetectEntitiesResult> batchDetectEntitiesAsync(BatchDetectEntitiesRequest request, final AsyncHandler<BatchDetectEntitiesRequest, BatchDetectEntitiesResult> asyncHandler) {
        final BatchDetectEntitiesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchDetectEntitiesResult>(){

            @Override
            public BatchDetectEntitiesResult call() throws Exception {
                BatchDetectEntitiesResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeBatchDetectEntities(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchDetectKeyPhrasesResult> batchDetectKeyPhrasesAsync(BatchDetectKeyPhrasesRequest request) {
        return this.batchDetectKeyPhrasesAsync(request, null);
    }

    @Override
    public Future<BatchDetectKeyPhrasesResult> batchDetectKeyPhrasesAsync(BatchDetectKeyPhrasesRequest request, final AsyncHandler<BatchDetectKeyPhrasesRequest, BatchDetectKeyPhrasesResult> asyncHandler) {
        final BatchDetectKeyPhrasesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchDetectKeyPhrasesResult>(){

            @Override
            public BatchDetectKeyPhrasesResult call() throws Exception {
                BatchDetectKeyPhrasesResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeBatchDetectKeyPhrases(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchDetectSentimentResult> batchDetectSentimentAsync(BatchDetectSentimentRequest request) {
        return this.batchDetectSentimentAsync(request, null);
    }

    @Override
    public Future<BatchDetectSentimentResult> batchDetectSentimentAsync(BatchDetectSentimentRequest request, final AsyncHandler<BatchDetectSentimentRequest, BatchDetectSentimentResult> asyncHandler) {
        final BatchDetectSentimentRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchDetectSentimentResult>(){

            @Override
            public BatchDetectSentimentResult call() throws Exception {
                BatchDetectSentimentResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeBatchDetectSentiment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTopicsDetectionJobResult> describeTopicsDetectionJobAsync(DescribeTopicsDetectionJobRequest request) {
        return this.describeTopicsDetectionJobAsync(request, null);
    }

    @Override
    public Future<DescribeTopicsDetectionJobResult> describeTopicsDetectionJobAsync(DescribeTopicsDetectionJobRequest request, final AsyncHandler<DescribeTopicsDetectionJobRequest, DescribeTopicsDetectionJobResult> asyncHandler) {
        final DescribeTopicsDetectionJobRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeTopicsDetectionJobResult>(){

            @Override
            public DescribeTopicsDetectionJobResult call() throws Exception {
                DescribeTopicsDetectionJobResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeDescribeTopicsDetectionJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetectDominantLanguageResult> detectDominantLanguageAsync(DetectDominantLanguageRequest request) {
        return this.detectDominantLanguageAsync(request, null);
    }

    @Override
    public Future<DetectDominantLanguageResult> detectDominantLanguageAsync(DetectDominantLanguageRequest request, final AsyncHandler<DetectDominantLanguageRequest, DetectDominantLanguageResult> asyncHandler) {
        final DetectDominantLanguageRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DetectDominantLanguageResult>(){

            @Override
            public DetectDominantLanguageResult call() throws Exception {
                DetectDominantLanguageResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeDetectDominantLanguage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetectEntitiesResult> detectEntitiesAsync(DetectEntitiesRequest request) {
        return this.detectEntitiesAsync(request, null);
    }

    @Override
    public Future<DetectEntitiesResult> detectEntitiesAsync(DetectEntitiesRequest request, final AsyncHandler<DetectEntitiesRequest, DetectEntitiesResult> asyncHandler) {
        final DetectEntitiesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DetectEntitiesResult>(){

            @Override
            public DetectEntitiesResult call() throws Exception {
                DetectEntitiesResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeDetectEntities(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetectKeyPhrasesResult> detectKeyPhrasesAsync(DetectKeyPhrasesRequest request) {
        return this.detectKeyPhrasesAsync(request, null);
    }

    @Override
    public Future<DetectKeyPhrasesResult> detectKeyPhrasesAsync(DetectKeyPhrasesRequest request, final AsyncHandler<DetectKeyPhrasesRequest, DetectKeyPhrasesResult> asyncHandler) {
        final DetectKeyPhrasesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DetectKeyPhrasesResult>(){

            @Override
            public DetectKeyPhrasesResult call() throws Exception {
                DetectKeyPhrasesResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeDetectKeyPhrases(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetectSentimentResult> detectSentimentAsync(DetectSentimentRequest request) {
        return this.detectSentimentAsync(request, null);
    }

    @Override
    public Future<DetectSentimentResult> detectSentimentAsync(DetectSentimentRequest request, final AsyncHandler<DetectSentimentRequest, DetectSentimentResult> asyncHandler) {
        final DetectSentimentRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DetectSentimentResult>(){

            @Override
            public DetectSentimentResult call() throws Exception {
                DetectSentimentResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeDetectSentiment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTopicsDetectionJobsResult> listTopicsDetectionJobsAsync(ListTopicsDetectionJobsRequest request) {
        return this.listTopicsDetectionJobsAsync(request, null);
    }

    @Override
    public Future<ListTopicsDetectionJobsResult> listTopicsDetectionJobsAsync(ListTopicsDetectionJobsRequest request, final AsyncHandler<ListTopicsDetectionJobsRequest, ListTopicsDetectionJobsResult> asyncHandler) {
        final ListTopicsDetectionJobsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTopicsDetectionJobsResult>(){

            @Override
            public ListTopicsDetectionJobsResult call() throws Exception {
                ListTopicsDetectionJobsResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeListTopicsDetectionJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartTopicsDetectionJobResult> startTopicsDetectionJobAsync(StartTopicsDetectionJobRequest request) {
        return this.startTopicsDetectionJobAsync(request, null);
    }

    @Override
    public Future<StartTopicsDetectionJobResult> startTopicsDetectionJobAsync(StartTopicsDetectionJobRequest request, final AsyncHandler<StartTopicsDetectionJobRequest, StartTopicsDetectionJobResult> asyncHandler) {
        final StartTopicsDetectionJobRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartTopicsDetectionJobResult>(){

            @Override
            public StartTopicsDetectionJobResult call() throws Exception {
                StartTopicsDetectionJobResult result = null;
                try {
                    result = AmazonComprehendAsyncClient.this.executeStartTopicsDetectionJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

