/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.apigateway.model.ConnectionType;
import com.amazonaws.services.apigateway.model.ContentHandlingStrategy;
import com.amazonaws.services.apigateway.model.IntegrationResponse;
import com.amazonaws.services.apigateway.model.IntegrationType;
import com.amazonaws.services.apigateway.model.transform.IntegrationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Integration
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private String httpMethod;
    private String uri;
    private String connectionType;
    private String connectionId;
    private String credentials;
    private Map<String, String> requestParameters;
    private Map<String, String> requestTemplates;
    private String passthroughBehavior;
    private String contentHandling;
    private Integer timeoutInMillis;
    private String cacheNamespace;
    private List<String> cacheKeyParameters;
    private Map<String, IntegrationResponse> integrationResponses;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Integration withType(String type) {
        this.setType(type);
        return this;
    }

    public void setType(IntegrationType type) {
        this.withType(type);
    }

    public Integration withType(IntegrationType type) {
        this.type = type.toString();
        return this;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public Integration withHttpMethod(String httpMethod) {
        this.setHttpMethod(httpMethod);
        return this;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public Integration withUri(String uri) {
        this.setUri(uri);
        return this;
    }

    public void setConnectionType(String connectionType) {
        this.connectionType = connectionType;
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    public Integration withConnectionType(String connectionType) {
        this.setConnectionType(connectionType);
        return this;
    }

    public void setConnectionType(ConnectionType connectionType) {
        this.withConnectionType(connectionType);
    }

    public Integration withConnectionType(ConnectionType connectionType) {
        this.connectionType = connectionType.toString();
        return this;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public Integration withConnectionId(String connectionId) {
        this.setConnectionId(connectionId);
        return this;
    }

    public void setCredentials(String credentials) {
        this.credentials = credentials;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public Integration withCredentials(String credentials) {
        this.setCredentials(credentials);
        return this;
    }

    public Map<String, String> getRequestParameters() {
        return this.requestParameters;
    }

    public void setRequestParameters(Map<String, String> requestParameters) {
        this.requestParameters = requestParameters;
    }

    public Integration withRequestParameters(Map<String, String> requestParameters) {
        this.setRequestParameters(requestParameters);
        return this;
    }

    public Integration addRequestParametersEntry(String key, String value) {
        if (null == this.requestParameters) {
            this.requestParameters = new HashMap<String, String>();
        }
        if (this.requestParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.requestParameters.put(key, value);
        return this;
    }

    public Integration clearRequestParametersEntries() {
        this.requestParameters = null;
        return this;
    }

    public Map<String, String> getRequestTemplates() {
        return this.requestTemplates;
    }

    public void setRequestTemplates(Map<String, String> requestTemplates) {
        this.requestTemplates = requestTemplates;
    }

    public Integration withRequestTemplates(Map<String, String> requestTemplates) {
        this.setRequestTemplates(requestTemplates);
        return this;
    }

    public Integration addRequestTemplatesEntry(String key, String value) {
        if (null == this.requestTemplates) {
            this.requestTemplates = new HashMap<String, String>();
        }
        if (this.requestTemplates.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.requestTemplates.put(key, value);
        return this;
    }

    public Integration clearRequestTemplatesEntries() {
        this.requestTemplates = null;
        return this;
    }

    public void setPassthroughBehavior(String passthroughBehavior) {
        this.passthroughBehavior = passthroughBehavior;
    }

    public String getPassthroughBehavior() {
        return this.passthroughBehavior;
    }

    public Integration withPassthroughBehavior(String passthroughBehavior) {
        this.setPassthroughBehavior(passthroughBehavior);
        return this;
    }

    public void setContentHandling(String contentHandling) {
        this.contentHandling = contentHandling;
    }

    public String getContentHandling() {
        return this.contentHandling;
    }

    public Integration withContentHandling(String contentHandling) {
        this.setContentHandling(contentHandling);
        return this;
    }

    public void setContentHandling(ContentHandlingStrategy contentHandling) {
        this.withContentHandling(contentHandling);
    }

    public Integration withContentHandling(ContentHandlingStrategy contentHandling) {
        this.contentHandling = contentHandling.toString();
        return this;
    }

    public void setTimeoutInMillis(Integer timeoutInMillis) {
        this.timeoutInMillis = timeoutInMillis;
    }

    public Integer getTimeoutInMillis() {
        return this.timeoutInMillis;
    }

    public Integration withTimeoutInMillis(Integer timeoutInMillis) {
        this.setTimeoutInMillis(timeoutInMillis);
        return this;
    }

    public void setCacheNamespace(String cacheNamespace) {
        this.cacheNamespace = cacheNamespace;
    }

    public String getCacheNamespace() {
        return this.cacheNamespace;
    }

    public Integration withCacheNamespace(String cacheNamespace) {
        this.setCacheNamespace(cacheNamespace);
        return this;
    }

    public List<String> getCacheKeyParameters() {
        return this.cacheKeyParameters;
    }

    public void setCacheKeyParameters(Collection<String> cacheKeyParameters) {
        if (cacheKeyParameters == null) {
            this.cacheKeyParameters = null;
            return;
        }
        this.cacheKeyParameters = new ArrayList<String>(cacheKeyParameters);
    }

    public Integration withCacheKeyParameters(String ... cacheKeyParameters) {
        if (this.cacheKeyParameters == null) {
            this.setCacheKeyParameters(new ArrayList<String>(cacheKeyParameters.length));
        }
        for (String ele : cacheKeyParameters) {
            this.cacheKeyParameters.add(ele);
        }
        return this;
    }

    public Integration withCacheKeyParameters(Collection<String> cacheKeyParameters) {
        this.setCacheKeyParameters(cacheKeyParameters);
        return this;
    }

    public Map<String, IntegrationResponse> getIntegrationResponses() {
        return this.integrationResponses;
    }

    public void setIntegrationResponses(Map<String, IntegrationResponse> integrationResponses) {
        this.integrationResponses = integrationResponses;
    }

    public Integration withIntegrationResponses(Map<String, IntegrationResponse> integrationResponses) {
        this.setIntegrationResponses(integrationResponses);
        return this;
    }

    public Integration addIntegrationResponsesEntry(String key, IntegrationResponse value) {
        if (null == this.integrationResponses) {
            this.integrationResponses = new HashMap<String, IntegrationResponse>();
        }
        if (this.integrationResponses.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.integrationResponses.put(key, value);
        return this;
    }

    public Integration clearIntegrationResponsesEntries() {
        this.integrationResponses = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getHttpMethod() != null) {
            sb.append("HttpMethod: ").append(this.getHttpMethod()).append(",");
        }
        if (this.getUri() != null) {
            sb.append("Uri: ").append(this.getUri()).append(",");
        }
        if (this.getConnectionType() != null) {
            sb.append("ConnectionType: ").append(this.getConnectionType()).append(",");
        }
        if (this.getConnectionId() != null) {
            sb.append("ConnectionId: ").append(this.getConnectionId()).append(",");
        }
        if (this.getCredentials() != null) {
            sb.append("Credentials: ").append(this.getCredentials()).append(",");
        }
        if (this.getRequestParameters() != null) {
            sb.append("RequestParameters: ").append(this.getRequestParameters()).append(",");
        }
        if (this.getRequestTemplates() != null) {
            sb.append("RequestTemplates: ").append(this.getRequestTemplates()).append(",");
        }
        if (this.getPassthroughBehavior() != null) {
            sb.append("PassthroughBehavior: ").append(this.getPassthroughBehavior()).append(",");
        }
        if (this.getContentHandling() != null) {
            sb.append("ContentHandling: ").append(this.getContentHandling()).append(",");
        }
        if (this.getTimeoutInMillis() != null) {
            sb.append("TimeoutInMillis: ").append(this.getTimeoutInMillis()).append(",");
        }
        if (this.getCacheNamespace() != null) {
            sb.append("CacheNamespace: ").append(this.getCacheNamespace()).append(",");
        }
        if (this.getCacheKeyParameters() != null) {
            sb.append("CacheKeyParameters: ").append(this.getCacheKeyParameters()).append(",");
        }
        if (this.getIntegrationResponses() != null) {
            sb.append("IntegrationResponses: ").append(this.getIntegrationResponses());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Integration)) {
            return false;
        }
        Integration other = (Integration)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getHttpMethod() == null ^ this.getHttpMethod() == null) {
            return false;
        }
        if (other.getHttpMethod() != null && !other.getHttpMethod().equals(this.getHttpMethod())) {
            return false;
        }
        if (other.getUri() == null ^ this.getUri() == null) {
            return false;
        }
        if (other.getUri() != null && !other.getUri().equals(this.getUri())) {
            return false;
        }
        if (other.getConnectionType() == null ^ this.getConnectionType() == null) {
            return false;
        }
        if (other.getConnectionType() != null && !other.getConnectionType().equals(this.getConnectionType())) {
            return false;
        }
        if (other.getConnectionId() == null ^ this.getConnectionId() == null) {
            return false;
        }
        if (other.getConnectionId() != null && !other.getConnectionId().equals(this.getConnectionId())) {
            return false;
        }
        if (other.getCredentials() == null ^ this.getCredentials() == null) {
            return false;
        }
        if (other.getCredentials() != null && !other.getCredentials().equals(this.getCredentials())) {
            return false;
        }
        if (other.getRequestParameters() == null ^ this.getRequestParameters() == null) {
            return false;
        }
        if (other.getRequestParameters() != null && !other.getRequestParameters().equals(this.getRequestParameters())) {
            return false;
        }
        if (other.getRequestTemplates() == null ^ this.getRequestTemplates() == null) {
            return false;
        }
        if (other.getRequestTemplates() != null && !other.getRequestTemplates().equals(this.getRequestTemplates())) {
            return false;
        }
        if (other.getPassthroughBehavior() == null ^ this.getPassthroughBehavior() == null) {
            return false;
        }
        if (other.getPassthroughBehavior() != null && !other.getPassthroughBehavior().equals(this.getPassthroughBehavior())) {
            return false;
        }
        if (other.getContentHandling() == null ^ this.getContentHandling() == null) {
            return false;
        }
        if (other.getContentHandling() != null && !other.getContentHandling().equals(this.getContentHandling())) {
            return false;
        }
        if (other.getTimeoutInMillis() == null ^ this.getTimeoutInMillis() == null) {
            return false;
        }
        if (other.getTimeoutInMillis() != null && !other.getTimeoutInMillis().equals(this.getTimeoutInMillis())) {
            return false;
        }
        if (other.getCacheNamespace() == null ^ this.getCacheNamespace() == null) {
            return false;
        }
        if (other.getCacheNamespace() != null && !other.getCacheNamespace().equals(this.getCacheNamespace())) {
            return false;
        }
        if (other.getCacheKeyParameters() == null ^ this.getCacheKeyParameters() == null) {
            return false;
        }
        if (other.getCacheKeyParameters() != null && !other.getCacheKeyParameters().equals(this.getCacheKeyParameters())) {
            return false;
        }
        if (other.getIntegrationResponses() == null ^ this.getIntegrationResponses() == null) {
            return false;
        }
        return other.getIntegrationResponses() == null || other.getIntegrationResponses().equals(this.getIntegrationResponses());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getHttpMethod() == null ? 0 : this.getHttpMethod().hashCode());
        hashCode = 31 * hashCode + (this.getUri() == null ? 0 : this.getUri().hashCode());
        hashCode = 31 * hashCode + (this.getConnectionType() == null ? 0 : this.getConnectionType().hashCode());
        hashCode = 31 * hashCode + (this.getConnectionId() == null ? 0 : this.getConnectionId().hashCode());
        hashCode = 31 * hashCode + (this.getCredentials() == null ? 0 : this.getCredentials().hashCode());
        hashCode = 31 * hashCode + (this.getRequestParameters() == null ? 0 : this.getRequestParameters().hashCode());
        hashCode = 31 * hashCode + (this.getRequestTemplates() == null ? 0 : this.getRequestTemplates().hashCode());
        hashCode = 31 * hashCode + (this.getPassthroughBehavior() == null ? 0 : this.getPassthroughBehavior().hashCode());
        hashCode = 31 * hashCode + (this.getContentHandling() == null ? 0 : this.getContentHandling().hashCode());
        hashCode = 31 * hashCode + (this.getTimeoutInMillis() == null ? 0 : this.getTimeoutInMillis().hashCode());
        hashCode = 31 * hashCode + (this.getCacheNamespace() == null ? 0 : this.getCacheNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getCacheKeyParameters() == null ? 0 : this.getCacheKeyParameters().hashCode());
        hashCode = 31 * hashCode + (this.getIntegrationResponses() == null ? 0 : this.getIntegrationResponses().hashCode());
        return hashCode;
    }

    public Integration clone() {
        try {
            return (Integration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IntegrationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

