/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.serverlessapplicationrepository;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.serverlessapplicationrepository.AWSServerlessApplicationRepositoryAsync;
import com.amazonaws.services.serverlessapplicationrepository.AWSServerlessApplicationRepositoryAsyncClientBuilder;
import com.amazonaws.services.serverlessapplicationrepository.AWSServerlessApplicationRepositoryClient;
import com.amazonaws.services.serverlessapplicationrepository.model.CreateApplicationRequest;
import com.amazonaws.services.serverlessapplicationrepository.model.CreateApplicationResult;
import com.amazonaws.services.serverlessapplicationrepository.model.CreateApplicationVersionRequest;
import com.amazonaws.services.serverlessapplicationrepository.model.CreateApplicationVersionResult;
import com.amazonaws.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest;
import com.amazonaws.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResult;
import com.amazonaws.services.serverlessapplicationrepository.model.DeleteApplicationRequest;
import com.amazonaws.services.serverlessapplicationrepository.model.DeleteApplicationResult;
import com.amazonaws.services.serverlessapplicationrepository.model.GetApplicationPolicyRequest;
import com.amazonaws.services.serverlessapplicationrepository.model.GetApplicationPolicyResult;
import com.amazonaws.services.serverlessapplicationrepository.model.GetApplicationRequest;
import com.amazonaws.services.serverlessapplicationrepository.model.GetApplicationResult;
import com.amazonaws.services.serverlessapplicationrepository.model.ListApplicationVersionsRequest;
import com.amazonaws.services.serverlessapplicationrepository.model.ListApplicationVersionsResult;
import com.amazonaws.services.serverlessapplicationrepository.model.ListApplicationsRequest;
import com.amazonaws.services.serverlessapplicationrepository.model.ListApplicationsResult;
import com.amazonaws.services.serverlessapplicationrepository.model.PutApplicationPolicyRequest;
import com.amazonaws.services.serverlessapplicationrepository.model.PutApplicationPolicyResult;
import com.amazonaws.services.serverlessapplicationrepository.model.UpdateApplicationRequest;
import com.amazonaws.services.serverlessapplicationrepository.model.UpdateApplicationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSServerlessApplicationRepositoryAsyncClient
extends AWSServerlessApplicationRepositoryClient
implements AWSServerlessApplicationRepositoryAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSServerlessApplicationRepositoryAsyncClientBuilder asyncBuilder() {
        return AWSServerlessApplicationRepositoryAsyncClientBuilder.standard();
    }

    AWSServerlessApplicationRepositoryAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateApplicationResult> createApplicationAsync(CreateApplicationRequest request) {
        return this.createApplicationAsync(request, null);
    }

    @Override
    public Future<CreateApplicationResult> createApplicationAsync(CreateApplicationRequest request, final AsyncHandler<CreateApplicationRequest, CreateApplicationResult> asyncHandler) {
        final CreateApplicationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateApplicationResult>(){

            @Override
            public CreateApplicationResult call() throws Exception {
                CreateApplicationResult result = null;
                try {
                    result = AWSServerlessApplicationRepositoryAsyncClient.this.executeCreateApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateApplicationVersionResult> createApplicationVersionAsync(CreateApplicationVersionRequest request) {
        return this.createApplicationVersionAsync(request, null);
    }

    @Override
    public Future<CreateApplicationVersionResult> createApplicationVersionAsync(CreateApplicationVersionRequest request, final AsyncHandler<CreateApplicationVersionRequest, CreateApplicationVersionResult> asyncHandler) {
        final CreateApplicationVersionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateApplicationVersionResult>(){

            @Override
            public CreateApplicationVersionResult call() throws Exception {
                CreateApplicationVersionResult result = null;
                try {
                    result = AWSServerlessApplicationRepositoryAsyncClient.this.executeCreateApplicationVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateCloudFormationChangeSetResult> createCloudFormationChangeSetAsync(CreateCloudFormationChangeSetRequest request) {
        return this.createCloudFormationChangeSetAsync(request, null);
    }

    @Override
    public Future<CreateCloudFormationChangeSetResult> createCloudFormationChangeSetAsync(CreateCloudFormationChangeSetRequest request, final AsyncHandler<CreateCloudFormationChangeSetRequest, CreateCloudFormationChangeSetResult> asyncHandler) {
        final CreateCloudFormationChangeSetRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateCloudFormationChangeSetResult>(){

            @Override
            public CreateCloudFormationChangeSetResult call() throws Exception {
                CreateCloudFormationChangeSetResult result = null;
                try {
                    result = AWSServerlessApplicationRepositoryAsyncClient.this.executeCreateCloudFormationChangeSet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteApplicationResult> deleteApplicationAsync(DeleteApplicationRequest request) {
        return this.deleteApplicationAsync(request, null);
    }

    @Override
    public Future<DeleteApplicationResult> deleteApplicationAsync(DeleteApplicationRequest request, final AsyncHandler<DeleteApplicationRequest, DeleteApplicationResult> asyncHandler) {
        final DeleteApplicationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteApplicationResult>(){

            @Override
            public DeleteApplicationResult call() throws Exception {
                DeleteApplicationResult result = null;
                try {
                    result = AWSServerlessApplicationRepositoryAsyncClient.this.executeDeleteApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetApplicationResult> getApplicationAsync(GetApplicationRequest request) {
        return this.getApplicationAsync(request, null);
    }

    @Override
    public Future<GetApplicationResult> getApplicationAsync(GetApplicationRequest request, final AsyncHandler<GetApplicationRequest, GetApplicationResult> asyncHandler) {
        final GetApplicationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetApplicationResult>(){

            @Override
            public GetApplicationResult call() throws Exception {
                GetApplicationResult result = null;
                try {
                    result = AWSServerlessApplicationRepositoryAsyncClient.this.executeGetApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetApplicationPolicyResult> getApplicationPolicyAsync(GetApplicationPolicyRequest request) {
        return this.getApplicationPolicyAsync(request, null);
    }

    @Override
    public Future<GetApplicationPolicyResult> getApplicationPolicyAsync(GetApplicationPolicyRequest request, final AsyncHandler<GetApplicationPolicyRequest, GetApplicationPolicyResult> asyncHandler) {
        final GetApplicationPolicyRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetApplicationPolicyResult>(){

            @Override
            public GetApplicationPolicyResult call() throws Exception {
                GetApplicationPolicyResult result = null;
                try {
                    result = AWSServerlessApplicationRepositoryAsyncClient.this.executeGetApplicationPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListApplicationVersionsResult> listApplicationVersionsAsync(ListApplicationVersionsRequest request) {
        return this.listApplicationVersionsAsync(request, null);
    }

    @Override
    public Future<ListApplicationVersionsResult> listApplicationVersionsAsync(ListApplicationVersionsRequest request, final AsyncHandler<ListApplicationVersionsRequest, ListApplicationVersionsResult> asyncHandler) {
        final ListApplicationVersionsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListApplicationVersionsResult>(){

            @Override
            public ListApplicationVersionsResult call() throws Exception {
                ListApplicationVersionsResult result = null;
                try {
                    result = AWSServerlessApplicationRepositoryAsyncClient.this.executeListApplicationVersions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListApplicationsResult> listApplicationsAsync(ListApplicationsRequest request) {
        return this.listApplicationsAsync(request, null);
    }

    @Override
    public Future<ListApplicationsResult> listApplicationsAsync(ListApplicationsRequest request, final AsyncHandler<ListApplicationsRequest, ListApplicationsResult> asyncHandler) {
        final ListApplicationsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListApplicationsResult>(){

            @Override
            public ListApplicationsResult call() throws Exception {
                ListApplicationsResult result = null;
                try {
                    result = AWSServerlessApplicationRepositoryAsyncClient.this.executeListApplications(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutApplicationPolicyResult> putApplicationPolicyAsync(PutApplicationPolicyRequest request) {
        return this.putApplicationPolicyAsync(request, null);
    }

    @Override
    public Future<PutApplicationPolicyResult> putApplicationPolicyAsync(PutApplicationPolicyRequest request, final AsyncHandler<PutApplicationPolicyRequest, PutApplicationPolicyResult> asyncHandler) {
        final PutApplicationPolicyRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutApplicationPolicyResult>(){

            @Override
            public PutApplicationPolicyResult call() throws Exception {
                PutApplicationPolicyResult result = null;
                try {
                    result = AWSServerlessApplicationRepositoryAsyncClient.this.executePutApplicationPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateApplicationResult> updateApplicationAsync(UpdateApplicationRequest request) {
        return this.updateApplicationAsync(request, null);
    }

    @Override
    public Future<UpdateApplicationResult> updateApplicationAsync(UpdateApplicationRequest request, final AsyncHandler<UpdateApplicationRequest, UpdateApplicationResult> asyncHandler) {
        final UpdateApplicationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateApplicationResult>(){

            @Override
            public UpdateApplicationResult call() throws Exception {
                UpdateApplicationResult result = null;
                try {
                    result = AWSServerlessApplicationRepositoryAsyncClient.this.executeUpdateApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

