/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo.internal.netty.util;

import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.util.StringUtils;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringEncoder;
import java.util.List;
import java.util.Map;

public final class RequestAdapter {
    public static HttpRequest adapt(Request<?> sdkRequest) {
        String uri = RequestAdapter.uriFrom(sdkRequest);
        HttpMethod method = RequestAdapter.toNettyHttpMethod(sdkRequest.getHttpMethod());
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, method, uri, (HttpHeaders)new DefaultHttpHeaders());
        for (Map.Entry<String, String> header : sdkRequest.getHeaders().entrySet()) {
            request.headers().add(header.getKey(), (Object)RequestAdapter.resolveValue(header.getValue()));
        }
        return request;
    }

    private static String resolveValue(String value) {
        return value == null ? "" : value;
    }

    private static String uriFrom(Request<?> sdkRequest) {
        StringBuilder uriBuilder = new StringBuilder(sdkRequest.getEndpoint().toString());
        if (!StringUtils.isNullOrEmpty(sdkRequest.getResourcePath())) {
            uriBuilder.append(sdkRequest.getResourcePath());
        }
        QueryStringEncoder encoder = new QueryStringEncoder(uriBuilder.toString());
        for (Map.Entry<String, List<String>> param : sdkRequest.getParameters().entrySet()) {
            for (String value : param.getValue()) {
                encoder.addParam(param.getKey(), value);
            }
        }
        return encoder.toString();
    }

    private static HttpMethod toNettyHttpMethod(HttpMethodName method) {
        return HttpMethod.valueOf((String)method.name());
    }
}

