/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.TargetGroupAttribute;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class ModifyTargetGroupAttributesRequestMarshaller
implements Marshaller<Request<ModifyTargetGroupAttributesRequest>, ModifyTargetGroupAttributesRequest> {
    @Override
    public Request<ModifyTargetGroupAttributesRequest> marshall(ModifyTargetGroupAttributesRequest modifyTargetGroupAttributesRequest) {
        if (modifyTargetGroupAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyTargetGroupAttributesRequest> request = new DefaultRequest<ModifyTargetGroupAttributesRequest>(modifyTargetGroupAttributesRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "ModifyTargetGroupAttributes");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyTargetGroupAttributesRequest.getTargetGroupArn() != null) {
            request.addParameter("TargetGroupArn", StringUtils.fromString(modifyTargetGroupAttributesRequest.getTargetGroupArn()));
        }
        if (modifyTargetGroupAttributesRequest.getAttributes() != null) {
            List<TargetGroupAttribute> attributesList = modifyTargetGroupAttributesRequest.getAttributes();
            if (attributesList.isEmpty()) {
                request.addParameter("Attributes", "");
            } else {
                int attributesListIndex = 1;
                for (TargetGroupAttribute attributesListValue : attributesList) {
                    if (attributesListValue.getKey() != null) {
                        request.addParameter("Attributes.member." + attributesListIndex + ".Key", StringUtils.fromString(attributesListValue.getKey()));
                    }
                    if (attributesListValue.getValue() != null) {
                        request.addParameter("Attributes.member." + attributesListIndex + ".Value", StringUtils.fromString(attributesListValue.getValue()));
                    }
                    ++attributesListIndex;
                }
            }
        }
        return request;
    }
}

