/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeVpcEndpointServicePermissionsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeVpcEndpointServicePermissionsRequestMarshaller
implements Marshaller<Request<DescribeVpcEndpointServicePermissionsRequest>, DescribeVpcEndpointServicePermissionsRequest> {
    @Override
    public Request<DescribeVpcEndpointServicePermissionsRequest> marshall(DescribeVpcEndpointServicePermissionsRequest describeVpcEndpointServicePermissionsRequest) {
        SdkInternalList describeVpcEndpointServicePermissionsRequestFiltersList;
        if (describeVpcEndpointServicePermissionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeVpcEndpointServicePermissionsRequest> request = new DefaultRequest<DescribeVpcEndpointServicePermissionsRequest>(describeVpcEndpointServicePermissionsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeVpcEndpointServicePermissions");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeVpcEndpointServicePermissionsRequest.getServiceId() != null) {
            request.addParameter("ServiceId", StringUtils.fromString(describeVpcEndpointServicePermissionsRequest.getServiceId()));
        }
        if (!(describeVpcEndpointServicePermissionsRequestFiltersList = (SdkInternalList)describeVpcEndpointServicePermissionsRequest.getFilters()).isEmpty() || !describeVpcEndpointServicePermissionsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeVpcEndpointServicePermissionsRequestFiltersListValue : describeVpcEndpointServicePermissionsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeVpcEndpointServicePermissionsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeVpcEndpointServicePermissionsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeVpcEndpointServicePermissionsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeVpcEndpointServicePermissionsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeVpcEndpointServicePermissionsRequest.getMaxResults()));
        }
        if (describeVpcEndpointServicePermissionsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeVpcEndpointServicePermissionsRequest.getNextToken()));
        }
        return request;
    }
}

