/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simpleworkflow.model.WorkflowTypeInfo;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowTypeJsonMarshaller;

public class WorkflowTypeInfoJsonMarshaller {
    private static WorkflowTypeInfoJsonMarshaller instance;

    public void marshall(WorkflowTypeInfo workflowTypeInfo, StructuredJsonGenerator jsonGenerator) {
        if (workflowTypeInfo == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (workflowTypeInfo.getWorkflowType() != null) {
                jsonGenerator.writeFieldName("workflowType");
                WorkflowTypeJsonMarshaller.getInstance().marshall(workflowTypeInfo.getWorkflowType(), jsonGenerator);
            }
            if (workflowTypeInfo.getStatus() != null) {
                jsonGenerator.writeFieldName("status").writeValue(workflowTypeInfo.getStatus());
            }
            if (workflowTypeInfo.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(workflowTypeInfo.getDescription());
            }
            if (workflowTypeInfo.getCreationDate() != null) {
                jsonGenerator.writeFieldName("creationDate").writeValue(workflowTypeInfo.getCreationDate());
            }
            if (workflowTypeInfo.getDeprecationDate() != null) {
                jsonGenerator.writeFieldName("deprecationDate").writeValue(workflowTypeInfo.getDeprecationDate());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static WorkflowTypeInfoJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new WorkflowTypeInfoJsonMarshaller();
        }
        return instance;
    }
}

