/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.NotificationConfig;

public class NotificationConfigJsonMarshaller {
    private static NotificationConfigJsonMarshaller instance;

    public void marshall(NotificationConfig notificationConfig, StructuredJsonGenerator jsonGenerator) {
        if (notificationConfig == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList notificationEventsList;
            jsonGenerator.writeStartObject();
            if (notificationConfig.getNotificationArn() != null) {
                jsonGenerator.writeFieldName("NotificationArn").writeValue(notificationConfig.getNotificationArn());
            }
            if (!(notificationEventsList = (SdkInternalList)notificationConfig.getNotificationEvents()).isEmpty() || !notificationEventsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("NotificationEvents");
                jsonGenerator.writeStartArray();
                for (String notificationEventsListValue : notificationEventsList) {
                    if (notificationEventsListValue == null) continue;
                    jsonGenerator.writeValue(notificationEventsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (notificationConfig.getNotificationType() != null) {
                jsonGenerator.writeFieldName("NotificationType").writeValue(notificationConfig.getNotificationType());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static NotificationConfigJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new NotificationConfigJsonMarshaller();
        }
        return instance;
    }
}

