/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardAnnotationMaps;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardParameterTypes;
import com.amazonaws.util.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@SdkInternalApi
final class StandardBeanProperties {
    StandardBeanProperties() {
    }

    static final <T, V> Map<String, Bean<T, V>> of(Class<T> clazz) {
        return Beans.CACHE.of(clazz);
    }

    static final boolean isGetter(Method method) {
        if (!method.getName().startsWith("get") && !method.getName().startsWith("is")) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        if (method.getReturnType() == Void.TYPE) {
            return false;
        }
        if (method.isBridge()) {
            return false;
        }
        if (method.isSynthetic()) {
            return false;
        }
        return method.getDeclaringClass() != Object.class;
    }

    static final String nameOf(Method getter, String prefix) {
        String name;
        if ((name = name.substring((name = getter.getName()).startsWith("is") ? "is".length() : "get".length())).length() == 0) {
            throw new DynamoDBMappingException("getter must begin with 'get' or 'is', and contain at least one character: " + getter);
        }
        if (prefix == null) {
            return StringUtils.lowerCase(name.substring(0, 1)) + name.substring(1);
        }
        return prefix + name;
    }

    static final Field declaredFieldOf(Method getter) {
        String name = StandardBeanProperties.nameOf(getter, null);
        try {
            return getter.getDeclaringClass().getDeclaredField(name);
        }
        catch (SecurityException e) {
            throw new DynamoDBMappingException("no access to field " + name + " for " + getter, e);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    static final Method declaredSetterOf(Method getter) {
        String name = StandardBeanProperties.nameOf(getter, "set");
        try {
            return getter.getDeclaringClass().getMethod(name, getter.getReturnType());
        }
        catch (Exception exception) {
            return null;
        }
    }

    static final class Builder<T, V> {
        private final Map<String, Bean<T, V>> map = new LinkedHashMap<String, Bean<T, V>>();
        private final Class<T> targetType;
        private final boolean inherited;

        Builder(Class<T> targetType, boolean inherited) {
            this.targetType = targetType;
            this.inherited = inherited;
        }

        public Map<String, Bean<T, V>> build() {
            for (Method m : this.targetType.getMethods()) {
                if (!StandardBeanProperties.isGetter(m) || !this.inherited && m.getDeclaringClass() != this.targetType && !StandardAnnotationMaps.of(m.getDeclaringClass()).typed()) continue;
                this.flatten(new MethodReflect(m), null);
            }
            return Collections.unmodifiableMap(this.map);
        }

        private void flatten(MethodReflect<T, V> reflect, String name) {
            StandardAnnotationMaps.FieldMap annotations = StandardAnnotationMaps.of(((MethodReflect)reflect).getter);
            if (annotations.ignore() != null) {
                return;
            }
            DynamoDBMapperFieldModel.Id<T> id = new DynamoDBMapperFieldModel.Id<T>(this.targetType, name == null ? annotations.attributeName() : name);
            if (annotations.flattened() == null) {
                if (this.map.put(id.name(), new Bean(reflect, annotations, id)) != null) {
                    throw new DynamoDBMappingException(id.format("duplicate attribute name", new Object[0]));
                }
            } else {
                Map<String, String> attributes = annotations.attributes();
                for (Method m : reflect.targetType().getMethods()) {
                    if (!StandardBeanProperties.isGetter(m) || (name = attributes.remove(StandardBeanProperties.nameOf(m, null))) == null) continue;
                    this.flatten(new DeclaringMethodReflect(m, reflect), name);
                }
                if (!attributes.isEmpty()) {
                    throw new DynamoDBMappingException(id.format("contains unknown flattened attribute(s): " + attributes, new Object[0]));
                }
            }
        }
    }

    private static final class DeclaringMethodReflect<T, V>
    extends MethodReflect<T, V> {
        private final MethodReflect<T, T> declaring;

        private DeclaringMethodReflect(Method getter, MethodReflect<T, T> declaring) {
            super(getter);
            this.declaring = declaring;
        }

        @Override
        public final V get(T object) {
            T declaringObject = this.declaring.get(object);
            if (declaringObject == null) {
                return null;
            }
            return super.get(declaringObject);
        }

        @Override
        public final void set(T object, V value) {
            T declaringObject = this.declaring.get(object);
            if (declaringObject == null) {
                try {
                    declaringObject = this.declaring.targetType().newInstance();
                }
                catch (Exception e) {
                    throw new DynamoDBMappingException("could not instantiate " + this.declaring.targetType(), e);
                }
                this.declaring.set(object, declaringObject);
            }
            super.set(declaringObject, value);
        }
    }

    private static class MethodReflect<T, V>
    implements DynamoDBMapperFieldModel.Reflect<T, V> {
        private final Method getter;
        private final Method setter;

        private MethodReflect(Method getter) {
            this.setter = StandardBeanProperties.declaredSetterOf(getter);
            this.getter = getter;
        }

        final Class<V> targetType() {
            return this.getter.getReturnType();
        }

        @Override
        public V get(T object) {
            try {
                return (V)this.getter.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                throw new DynamoDBMappingException("could not invoke " + this.getter + " on " + object.getClass(), e);
            }
        }

        @Override
        public void set(T object, V value) {
            try {
                this.setter.invoke(object, value);
            }
            catch (Exception e) {
                throw new DynamoDBMappingException("could not invoke " + this.setter + " on " + object.getClass(), e);
            }
        }
    }

    static final class Bean<T, V> {
        private final MethodReflect<T, V> reflect;
        private final StandardAnnotationMaps.FieldMap<V> annotations;
        private final StandardParameterTypes.ParamType<V> type;
        private final DynamoDBMapperFieldModel.Id<T> id;

        private Bean(MethodReflect<T, V> reflect, StandardAnnotationMaps.FieldMap<V> annotations, DynamoDBMapperFieldModel.Id<T> id) {
            this.type = StandardParameterTypes.ParamType.of(((MethodReflect)reflect).getter.getGenericReturnType(), new Type[0]);
            this.annotations = annotations;
            this.reflect = reflect;
            this.id = id;
        }

        final DynamoDBMapperFieldModel.Id<T> id() {
            return this.id;
        }

        final StandardAnnotationMaps.FieldMap<V> annotations() {
            return this.annotations;
        }

        final StandardParameterTypes.ParamType<V> type() {
            return this.type;
        }

        final DynamoDBMapperFieldModel.Reflect<T, V> reflect() {
            return this.reflect;
        }

        @Deprecated
        final Method getter() {
            return ((MethodReflect)this.reflect).getter;
        }

        @Deprecated
        final Method setter() {
            if (((MethodReflect)this.reflect).setter == null) {
                throw new DynamoDBMappingException("no access to public/one-argument setter for " + ((MethodReflect)this.reflect).getter);
            }
            return ((MethodReflect)this.reflect).setter;
        }
    }

    static final class Beans<T, V> {
        private static final Beans<?, ?> CACHE = new Beans();
        private final ConcurrentMap<Class<T>, Map<String, Bean<T, V>>> cache = new ConcurrentHashMap<Class<T>, Map<String, Bean<T, V>>>();

        Beans() {
        }

        public final Map<String, Bean<T, V>> of(Class<T> clazz) {
            if (!this.cache.containsKey(clazz)) {
                this.cache.putIfAbsent(clazz, new Builder(clazz, false).build());
            }
            return (Map)this.cache.get(clazz);
        }
    }
}

