/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverted;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardTypeConverters;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Date;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@DynamoDBTypeConverted(converter=Converter.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.FIELD, ElementType.METHOD})
public @interface DynamoDBTypeConvertedTimestamp {
    public String timeZone() default "UTC";

    public String pattern();

    public static final class Converter<T>
    implements DynamoDBTypeConverter<String, T> {
        private final DynamoDBTypeConverter<Date, T> converter;
        private final DateTimeFormatter formatter;

        public Converter(Class<T> targetType, DynamoDBTypeConvertedTimestamp annotation) {
            TimeZone tz = StandardTypeConverters.convert(annotation.timeZone(), TimeZone.class);
            this.formatter = DateTimeFormat.forPattern((String)annotation.pattern()).withZone(DateTimeZone.forTimeZone((TimeZone)tz));
            this.converter = StandardTypeConverters.converter(Date.class, targetType);
        }

        @Override
        public final String convert(T object) {
            return this.formatter.print((ReadableInstant)new DateTime((Object)this.converter.convert(object)));
        }

        @Override
        public final T unconvert(String object) {
            return this.converter.unconvert(this.formatter.parseDateTime(object).toDate());
        }
    }
}

