/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.simpledb.model.SelectRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class SelectRequestMarshaller
implements Marshaller<Request<SelectRequest>, SelectRequest> {
    @Override
    public Request<SelectRequest> marshall(SelectRequest selectRequest) {
        if (selectRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SelectRequest> request = new DefaultRequest<SelectRequest>(selectRequest, "AmazonSimpleDB");
        request.addParameter("Action", "Select");
        request.addParameter("Version", "2009-04-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (selectRequest.getSelectExpression() != null) {
            request.addParameter("SelectExpression", StringUtils.fromString(selectRequest.getSelectExpression()));
        }
        if (selectRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(selectRequest.getNextToken()));
        }
        if (selectRequest.getConsistentRead() != null) {
            request.addParameter("ConsistentRead", StringUtils.fromBoolean(selectRequest.getConsistentRead()));
        }
        return request;
    }
}

