/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model;

import com.amazonaws.services.servicecatalog.model.ProductViewAggregationValue;
import com.amazonaws.services.servicecatalog.model.ProductViewSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SearchProductsResult
implements Serializable,
Cloneable {
    private List<ProductViewSummary> productViewSummaries;
    private Map<String, List<ProductViewAggregationValue>> productViewAggregations;
    private String nextPageToken;

    public List<ProductViewSummary> getProductViewSummaries() {
        return this.productViewSummaries;
    }

    public void setProductViewSummaries(Collection<ProductViewSummary> productViewSummaries) {
        if (productViewSummaries == null) {
            this.productViewSummaries = null;
            return;
        }
        this.productViewSummaries = new ArrayList<ProductViewSummary>(productViewSummaries);
    }

    public SearchProductsResult withProductViewSummaries(ProductViewSummary ... productViewSummaries) {
        if (this.productViewSummaries == null) {
            this.setProductViewSummaries(new ArrayList<ProductViewSummary>(productViewSummaries.length));
        }
        for (ProductViewSummary ele : productViewSummaries) {
            this.productViewSummaries.add(ele);
        }
        return this;
    }

    public SearchProductsResult withProductViewSummaries(Collection<ProductViewSummary> productViewSummaries) {
        this.setProductViewSummaries(productViewSummaries);
        return this;
    }

    public Map<String, List<ProductViewAggregationValue>> getProductViewAggregations() {
        return this.productViewAggregations;
    }

    public void setProductViewAggregations(Map<String, List<ProductViewAggregationValue>> productViewAggregations) {
        this.productViewAggregations = productViewAggregations;
    }

    public SearchProductsResult withProductViewAggregations(Map<String, List<ProductViewAggregationValue>> productViewAggregations) {
        this.setProductViewAggregations(productViewAggregations);
        return this;
    }

    public SearchProductsResult addProductViewAggregationsEntry(String key, List<ProductViewAggregationValue> value) {
        if (null == this.productViewAggregations) {
            this.productViewAggregations = new HashMap<String, List<ProductViewAggregationValue>>();
        }
        if (this.productViewAggregations.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.productViewAggregations.put(key, value);
        return this;
    }

    public SearchProductsResult clearProductViewAggregationsEntries() {
        this.productViewAggregations = null;
        return this;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public SearchProductsResult withNextPageToken(String nextPageToken) {
        this.setNextPageToken(nextPageToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProductViewSummaries() != null) {
            sb.append("ProductViewSummaries: " + this.getProductViewSummaries() + ",");
        }
        if (this.getProductViewAggregations() != null) {
            sb.append("ProductViewAggregations: " + this.getProductViewAggregations() + ",");
        }
        if (this.getNextPageToken() != null) {
            sb.append("NextPageToken: " + this.getNextPageToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchProductsResult)) {
            return false;
        }
        SearchProductsResult other = (SearchProductsResult)obj;
        if (other.getProductViewSummaries() == null ^ this.getProductViewSummaries() == null) {
            return false;
        }
        if (other.getProductViewSummaries() != null && !other.getProductViewSummaries().equals(this.getProductViewSummaries())) {
            return false;
        }
        if (other.getProductViewAggregations() == null ^ this.getProductViewAggregations() == null) {
            return false;
        }
        if (other.getProductViewAggregations() != null && !other.getProductViewAggregations().equals(this.getProductViewAggregations())) {
            return false;
        }
        if (other.getNextPageToken() == null ^ this.getNextPageToken() == null) {
            return false;
        }
        return other.getNextPageToken() == null || other.getNextPageToken().equals(this.getNextPageToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProductViewSummaries() == null ? 0 : this.getProductViewSummaries().hashCode());
        hashCode = 31 * hashCode + (this.getProductViewAggregations() == null ? 0 : this.getProductViewAggregations().hashCode());
        hashCode = 31 * hashCode + (this.getNextPageToken() == null ? 0 : this.getNextPageToken().hashCode());
        return hashCode;
    }

    public SearchProductsResult clone() {
        try {
            return (SearchProductsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

