/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecr.model.BatchCheckLayerAvailabilityRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class BatchCheckLayerAvailabilityRequestMarshaller
implements Marshaller<Request<BatchCheckLayerAvailabilityRequest>, BatchCheckLayerAvailabilityRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public BatchCheckLayerAvailabilityRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<BatchCheckLayerAvailabilityRequest> marshall(BatchCheckLayerAvailabilityRequest batchCheckLayerAvailabilityRequest) {
        if (batchCheckLayerAvailabilityRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<BatchCheckLayerAvailabilityRequest> request = new DefaultRequest<BatchCheckLayerAvailabilityRequest>(batchCheckLayerAvailabilityRequest, "AmazonECR");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerRegistry_V20150921.BatchCheckLayerAvailability");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<String> layerDigestsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (batchCheckLayerAvailabilityRequest.getRegistryId() != null) {
                jsonGenerator.writeFieldName("registryId").writeValue(batchCheckLayerAvailabilityRequest.getRegistryId());
            }
            if (batchCheckLayerAvailabilityRequest.getRepositoryName() != null) {
                jsonGenerator.writeFieldName("repositoryName").writeValue(batchCheckLayerAvailabilityRequest.getRepositoryName());
            }
            if ((layerDigestsList = batchCheckLayerAvailabilityRequest.getLayerDigests()) != null) {
                jsonGenerator.writeFieldName("layerDigests");
                jsonGenerator.writeStartArray();
                for (String layerDigestsListValue : layerDigestsList) {
                    if (layerDigestsListValue == null) continue;
                    jsonGenerator.writeValue(layerDigestsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

