/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iot.model.CodeSigningCertificateChain;
import com.amazonaws.services.iot.model.CodeSigningSignature;
import com.amazonaws.services.iot.model.transform.CustomCodeSigningMarshaller;
import java.io.Serializable;

public class CustomCodeSigning
implements Serializable,
Cloneable,
StructuredPojo {
    private CodeSigningSignature signature;
    private CodeSigningCertificateChain certificateChain;
    private String hashAlgorithm;
    private String signatureAlgorithm;

    public void setSignature(CodeSigningSignature signature) {
        this.signature = signature;
    }

    public CodeSigningSignature getSignature() {
        return this.signature;
    }

    public CustomCodeSigning withSignature(CodeSigningSignature signature) {
        this.setSignature(signature);
        return this;
    }

    public void setCertificateChain(CodeSigningCertificateChain certificateChain) {
        this.certificateChain = certificateChain;
    }

    public CodeSigningCertificateChain getCertificateChain() {
        return this.certificateChain;
    }

    public CustomCodeSigning withCertificateChain(CodeSigningCertificateChain certificateChain) {
        this.setCertificateChain(certificateChain);
        return this;
    }

    public void setHashAlgorithm(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public CustomCodeSigning withHashAlgorithm(String hashAlgorithm) {
        this.setHashAlgorithm(hashAlgorithm);
        return this;
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public CustomCodeSigning withSignatureAlgorithm(String signatureAlgorithm) {
        this.setSignatureAlgorithm(signatureAlgorithm);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSignature() != null) {
            sb.append("Signature: ").append(this.getSignature()).append(",");
        }
        if (this.getCertificateChain() != null) {
            sb.append("CertificateChain: ").append(this.getCertificateChain()).append(",");
        }
        if (this.getHashAlgorithm() != null) {
            sb.append("HashAlgorithm: ").append(this.getHashAlgorithm()).append(",");
        }
        if (this.getSignatureAlgorithm() != null) {
            sb.append("SignatureAlgorithm: ").append(this.getSignatureAlgorithm());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomCodeSigning)) {
            return false;
        }
        CustomCodeSigning other = (CustomCodeSigning)obj;
        if (other.getSignature() == null ^ this.getSignature() == null) {
            return false;
        }
        if (other.getSignature() != null && !other.getSignature().equals(this.getSignature())) {
            return false;
        }
        if (other.getCertificateChain() == null ^ this.getCertificateChain() == null) {
            return false;
        }
        if (other.getCertificateChain() != null && !other.getCertificateChain().equals(this.getCertificateChain())) {
            return false;
        }
        if (other.getHashAlgorithm() == null ^ this.getHashAlgorithm() == null) {
            return false;
        }
        if (other.getHashAlgorithm() != null && !other.getHashAlgorithm().equals(this.getHashAlgorithm())) {
            return false;
        }
        if (other.getSignatureAlgorithm() == null ^ this.getSignatureAlgorithm() == null) {
            return false;
        }
        return other.getSignatureAlgorithm() == null || other.getSignatureAlgorithm().equals(this.getSignatureAlgorithm());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSignature() == null ? 0 : this.getSignature().hashCode());
        hashCode = 31 * hashCode + (this.getCertificateChain() == null ? 0 : this.getCertificateChain().hashCode());
        hashCode = 31 * hashCode + (this.getHashAlgorithm() == null ? 0 : this.getHashAlgorithm().hashCode());
        hashCode = 31 * hashCode + (this.getSignatureAlgorithm() == null ? 0 : this.getSignatureAlgorithm().hashCode());
        return hashCode;
    }

    public CustomCodeSigning clone() {
        try {
            return (CustomCodeSigning)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CustomCodeSigningMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

