/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ServiceState;
import com.amazonaws.services.ec2.model.ServiceTypeDetail;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ServiceConfiguration
implements Serializable,
Cloneable {
    private SdkInternalList<ServiceTypeDetail> serviceType;
    private String serviceId;
    private String serviceName;
    private String serviceState;
    private SdkInternalList<String> availabilityZones;
    private Boolean acceptanceRequired;
    private SdkInternalList<String> networkLoadBalancerArns;
    private SdkInternalList<String> baseEndpointDnsNames;
    private String privateDnsName;

    public List<ServiceTypeDetail> getServiceType() {
        if (this.serviceType == null) {
            this.serviceType = new SdkInternalList();
        }
        return this.serviceType;
    }

    public void setServiceType(Collection<ServiceTypeDetail> serviceType) {
        if (serviceType == null) {
            this.serviceType = null;
            return;
        }
        this.serviceType = new SdkInternalList<ServiceTypeDetail>(serviceType);
    }

    public ServiceConfiguration withServiceType(ServiceTypeDetail ... serviceType) {
        if (this.serviceType == null) {
            this.setServiceType(new SdkInternalList<ServiceTypeDetail>(serviceType.length));
        }
        for (ServiceTypeDetail ele : serviceType) {
            this.serviceType.add(ele);
        }
        return this;
    }

    public ServiceConfiguration withServiceType(Collection<ServiceTypeDetail> serviceType) {
        this.setServiceType(serviceType);
        return this;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public ServiceConfiguration withServiceId(String serviceId) {
        this.setServiceId(serviceId);
        return this;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public ServiceConfiguration withServiceName(String serviceName) {
        this.setServiceName(serviceName);
        return this;
    }

    public void setServiceState(String serviceState) {
        this.serviceState = serviceState;
    }

    public String getServiceState() {
        return this.serviceState;
    }

    public ServiceConfiguration withServiceState(String serviceState) {
        this.setServiceState(serviceState);
        return this;
    }

    public ServiceConfiguration withServiceState(ServiceState serviceState) {
        this.serviceState = serviceState.toString();
        return this;
    }

    public List<String> getAvailabilityZones() {
        if (this.availabilityZones == null) {
            this.availabilityZones = new SdkInternalList();
        }
        return this.availabilityZones;
    }

    public void setAvailabilityZones(Collection<String> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
            return;
        }
        this.availabilityZones = new SdkInternalList<String>(availabilityZones);
    }

    public ServiceConfiguration withAvailabilityZones(String ... availabilityZones) {
        if (this.availabilityZones == null) {
            this.setAvailabilityZones(new SdkInternalList<String>(availabilityZones.length));
        }
        for (String ele : availabilityZones) {
            this.availabilityZones.add(ele);
        }
        return this;
    }

    public ServiceConfiguration withAvailabilityZones(Collection<String> availabilityZones) {
        this.setAvailabilityZones(availabilityZones);
        return this;
    }

    public void setAcceptanceRequired(Boolean acceptanceRequired) {
        this.acceptanceRequired = acceptanceRequired;
    }

    public Boolean getAcceptanceRequired() {
        return this.acceptanceRequired;
    }

    public ServiceConfiguration withAcceptanceRequired(Boolean acceptanceRequired) {
        this.setAcceptanceRequired(acceptanceRequired);
        return this;
    }

    public Boolean isAcceptanceRequired() {
        return this.acceptanceRequired;
    }

    public List<String> getNetworkLoadBalancerArns() {
        if (this.networkLoadBalancerArns == null) {
            this.networkLoadBalancerArns = new SdkInternalList();
        }
        return this.networkLoadBalancerArns;
    }

    public void setNetworkLoadBalancerArns(Collection<String> networkLoadBalancerArns) {
        if (networkLoadBalancerArns == null) {
            this.networkLoadBalancerArns = null;
            return;
        }
        this.networkLoadBalancerArns = new SdkInternalList<String>(networkLoadBalancerArns);
    }

    public ServiceConfiguration withNetworkLoadBalancerArns(String ... networkLoadBalancerArns) {
        if (this.networkLoadBalancerArns == null) {
            this.setNetworkLoadBalancerArns(new SdkInternalList<String>(networkLoadBalancerArns.length));
        }
        for (String ele : networkLoadBalancerArns) {
            this.networkLoadBalancerArns.add(ele);
        }
        return this;
    }

    public ServiceConfiguration withNetworkLoadBalancerArns(Collection<String> networkLoadBalancerArns) {
        this.setNetworkLoadBalancerArns(networkLoadBalancerArns);
        return this;
    }

    public List<String> getBaseEndpointDnsNames() {
        if (this.baseEndpointDnsNames == null) {
            this.baseEndpointDnsNames = new SdkInternalList();
        }
        return this.baseEndpointDnsNames;
    }

    public void setBaseEndpointDnsNames(Collection<String> baseEndpointDnsNames) {
        if (baseEndpointDnsNames == null) {
            this.baseEndpointDnsNames = null;
            return;
        }
        this.baseEndpointDnsNames = new SdkInternalList<String>(baseEndpointDnsNames);
    }

    public ServiceConfiguration withBaseEndpointDnsNames(String ... baseEndpointDnsNames) {
        if (this.baseEndpointDnsNames == null) {
            this.setBaseEndpointDnsNames(new SdkInternalList<String>(baseEndpointDnsNames.length));
        }
        for (String ele : baseEndpointDnsNames) {
            this.baseEndpointDnsNames.add(ele);
        }
        return this;
    }

    public ServiceConfiguration withBaseEndpointDnsNames(Collection<String> baseEndpointDnsNames) {
        this.setBaseEndpointDnsNames(baseEndpointDnsNames);
        return this;
    }

    public void setPrivateDnsName(String privateDnsName) {
        this.privateDnsName = privateDnsName;
    }

    public String getPrivateDnsName() {
        return this.privateDnsName;
    }

    public ServiceConfiguration withPrivateDnsName(String privateDnsName) {
        this.setPrivateDnsName(privateDnsName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getServiceType() != null) {
            sb.append("ServiceType: ").append(this.getServiceType()).append(",");
        }
        if (this.getServiceId() != null) {
            sb.append("ServiceId: ").append(this.getServiceId()).append(",");
        }
        if (this.getServiceName() != null) {
            sb.append("ServiceName: ").append(this.getServiceName()).append(",");
        }
        if (this.getServiceState() != null) {
            sb.append("ServiceState: ").append(this.getServiceState()).append(",");
        }
        if (this.getAvailabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.getAvailabilityZones()).append(",");
        }
        if (this.getAcceptanceRequired() != null) {
            sb.append("AcceptanceRequired: ").append(this.getAcceptanceRequired()).append(",");
        }
        if (this.getNetworkLoadBalancerArns() != null) {
            sb.append("NetworkLoadBalancerArns: ").append(this.getNetworkLoadBalancerArns()).append(",");
        }
        if (this.getBaseEndpointDnsNames() != null) {
            sb.append("BaseEndpointDnsNames: ").append(this.getBaseEndpointDnsNames()).append(",");
        }
        if (this.getPrivateDnsName() != null) {
            sb.append("PrivateDnsName: ").append(this.getPrivateDnsName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceConfiguration)) {
            return false;
        }
        ServiceConfiguration other = (ServiceConfiguration)obj;
        if (other.getServiceType() == null ^ this.getServiceType() == null) {
            return false;
        }
        if (other.getServiceType() != null && !other.getServiceType().equals(this.getServiceType())) {
            return false;
        }
        if (other.getServiceId() == null ^ this.getServiceId() == null) {
            return false;
        }
        if (other.getServiceId() != null && !other.getServiceId().equals(this.getServiceId())) {
            return false;
        }
        if (other.getServiceName() == null ^ this.getServiceName() == null) {
            return false;
        }
        if (other.getServiceName() != null && !other.getServiceName().equals(this.getServiceName())) {
            return false;
        }
        if (other.getServiceState() == null ^ this.getServiceState() == null) {
            return false;
        }
        if (other.getServiceState() != null && !other.getServiceState().equals(this.getServiceState())) {
            return false;
        }
        if (other.getAvailabilityZones() == null ^ this.getAvailabilityZones() == null) {
            return false;
        }
        if (other.getAvailabilityZones() != null && !other.getAvailabilityZones().equals(this.getAvailabilityZones())) {
            return false;
        }
        if (other.getAcceptanceRequired() == null ^ this.getAcceptanceRequired() == null) {
            return false;
        }
        if (other.getAcceptanceRequired() != null && !other.getAcceptanceRequired().equals(this.getAcceptanceRequired())) {
            return false;
        }
        if (other.getNetworkLoadBalancerArns() == null ^ this.getNetworkLoadBalancerArns() == null) {
            return false;
        }
        if (other.getNetworkLoadBalancerArns() != null && !other.getNetworkLoadBalancerArns().equals(this.getNetworkLoadBalancerArns())) {
            return false;
        }
        if (other.getBaseEndpointDnsNames() == null ^ this.getBaseEndpointDnsNames() == null) {
            return false;
        }
        if (other.getBaseEndpointDnsNames() != null && !other.getBaseEndpointDnsNames().equals(this.getBaseEndpointDnsNames())) {
            return false;
        }
        if (other.getPrivateDnsName() == null ^ this.getPrivateDnsName() == null) {
            return false;
        }
        return other.getPrivateDnsName() == null || other.getPrivateDnsName().equals(this.getPrivateDnsName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getServiceType() == null ? 0 : this.getServiceType().hashCode());
        hashCode = 31 * hashCode + (this.getServiceId() == null ? 0 : this.getServiceId().hashCode());
        hashCode = 31 * hashCode + (this.getServiceName() == null ? 0 : this.getServiceName().hashCode());
        hashCode = 31 * hashCode + (this.getServiceState() == null ? 0 : this.getServiceState().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZones() == null ? 0 : this.getAvailabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.getAcceptanceRequired() == null ? 0 : this.getAcceptanceRequired().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkLoadBalancerArns() == null ? 0 : this.getNetworkLoadBalancerArns().hashCode());
        hashCode = 31 * hashCode + (this.getBaseEndpointDnsNames() == null ? 0 : this.getBaseEndpointDnsNames().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateDnsName() == null ? 0 : this.getPrivateDnsName().hashCode());
        return hashCode;
    }

    public ServiceConfiguration clone() {
        try {
            return (ServiceConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

