/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.comprehend.model.SentimentScore;

@SdkInternalApi
public class SentimentScoreMarshaller {
    private static final MarshallingInfo<Float> POSITIVE_BINDING = MarshallingInfo.builder(MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Positive").build();
    private static final MarshallingInfo<Float> NEGATIVE_BINDING = MarshallingInfo.builder(MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Negative").build();
    private static final MarshallingInfo<Float> NEUTRAL_BINDING = MarshallingInfo.builder(MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Neutral").build();
    private static final MarshallingInfo<Float> MIXED_BINDING = MarshallingInfo.builder(MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Mixed").build();
    private static final SentimentScoreMarshaller instance = new SentimentScoreMarshaller();

    public static SentimentScoreMarshaller getInstance() {
        return instance;
    }

    public void marshall(SentimentScore sentimentScore, ProtocolMarshaller protocolMarshaller) {
        if (sentimentScore == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(sentimentScore.getPositive(), POSITIVE_BINDING);
            protocolMarshaller.marshall(sentimentScore.getNegative(), NEGATIVE_BINDING);
            protocolMarshaller.marshall(sentimentScore.getNeutral(), NEUTRAL_BINDING);
            protocolMarshaller.marshall(sentimentScore.getMixed(), MIXED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

