/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.identitymanagement.model.GetInstanceProfileRequest;
import com.amazonaws.services.identitymanagement.model.GetInstanceProfileResult;
import com.amazonaws.services.identitymanagement.model.GetUserRequest;
import com.amazonaws.services.identitymanagement.model.GetUserResult;
import com.amazonaws.services.identitymanagement.waiters.GetInstanceProfileFunction;
import com.amazonaws.services.identitymanagement.waiters.GetUserFunction;
import com.amazonaws.services.identitymanagement.waiters.UserExists;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.HttpFailureStatusAcceptor;
import com.amazonaws.waiters.HttpSuccessStatusAcceptor;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterState;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AmazonIdentityManagementWaiters {
    private final AmazonIdentityManagement client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonIdentityManagementWaiters(AmazonIdentityManagement client) {
        this.client = client;
    }

    public Waiter instanceProfileExists() {
        return new WaiterBuilder<GetInstanceProfileRequest, GetInstanceProfileResult>().withSdkFunction(new GetInstanceProfileFunction(this.client)).withAcceptors(new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new HttpFailureStatusAcceptor(404, WaiterState.RETRY)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(40), new FixedDelayStrategy(1))).withExecutorService(this.executorService).build();
    }

    public Waiter userExists() {
        return new WaiterBuilder<GetUserRequest, GetUserResult>().withSdkFunction(new GetUserFunction(this.client)).withAcceptors(new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new UserExists.IsNoSuchEntityMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(1))).withExecutorService(this.executorService).build();
    }
}

