/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.PrefixList;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class PrefixListStaxUnmarshaller
implements Unmarshaller<PrefixList, StaxUnmarshallerContext> {
    private static PrefixListStaxUnmarshaller instance;

    @Override
    public PrefixList unmarshall(StaxUnmarshallerContext context) throws Exception {
        PrefixList prefixList = new PrefixList();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return prefixList;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("prefixListId", targetDepth)) {
                    prefixList.setPrefixListId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("prefixListName", targetDepth)) {
                    prefixList.setPrefixListName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("cidrSet/item", targetDepth)) continue;
                prefixList.withCidrs(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return prefixList;
    }

    public static PrefixListStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PrefixListStaxUnmarshaller();
        }
        return instance;
    }
}

