/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.datapipeline.model.PollForTaskRequest;
import com.amazonaws.services.datapipeline.model.transform.InstanceIdentityJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class PollForTaskRequestMarshaller
implements Marshaller<Request<PollForTaskRequest>, PollForTaskRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public PollForTaskRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<PollForTaskRequest> marshall(PollForTaskRequest pollForTaskRequest) {
        if (pollForTaskRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PollForTaskRequest> request = new DefaultRequest<PollForTaskRequest>(pollForTaskRequest, "DataPipeline");
        request.addHeader("X-Amz-Target", "DataPipeline.PollForTask");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (pollForTaskRequest.getWorkerGroup() != null) {
                jsonGenerator.writeFieldName("workerGroup").writeValue(pollForTaskRequest.getWorkerGroup());
            }
            if (pollForTaskRequest.getHostname() != null) {
                jsonGenerator.writeFieldName("hostname").writeValue(pollForTaskRequest.getHostname());
            }
            if (pollForTaskRequest.getInstanceIdentity() != null) {
                jsonGenerator.writeFieldName("instanceIdentity");
                InstanceIdentityJsonMarshaller.getInstance().marshall(pollForTaskRequest.getInstanceIdentity(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

