/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workdocs.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.workdocs.model.Activity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeActivitiesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Activity> userActivities;
    private String marker;

    public List<Activity> getUserActivities() {
        return this.userActivities;
    }

    public void setUserActivities(Collection<Activity> userActivities) {
        if (userActivities == null) {
            this.userActivities = null;
            return;
        }
        this.userActivities = new ArrayList<Activity>(userActivities);
    }

    public DescribeActivitiesResult withUserActivities(Activity ... userActivities) {
        if (this.userActivities == null) {
            this.setUserActivities(new ArrayList<Activity>(userActivities.length));
        }
        for (Activity ele : userActivities) {
            this.userActivities.add(ele);
        }
        return this;
    }

    public DescribeActivitiesResult withUserActivities(Collection<Activity> userActivities) {
        this.setUserActivities(userActivities);
        return this;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public DescribeActivitiesResult withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUserActivities() != null) {
            sb.append("UserActivities: ").append(this.getUserActivities()).append(",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: ").append(this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeActivitiesResult)) {
            return false;
        }
        DescribeActivitiesResult other = (DescribeActivitiesResult)obj;
        if (other.getUserActivities() == null ^ this.getUserActivities() == null) {
            return false;
        }
        if (other.getUserActivities() != null && !other.getUserActivities().equals(this.getUserActivities())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUserActivities() == null ? 0 : this.getUserActivities().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public DescribeActivitiesResult clone() {
        try {
            return (DescribeActivitiesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

