/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.core;

import com.amazonaws.services.simpleworkflow.flow.core.AsyncContextBase;
import com.amazonaws.services.simpleworkflow.flow.core.AsyncEventLoop;
import com.amazonaws.services.simpleworkflow.flow.core.AsyncParentContext;
import com.amazonaws.services.simpleworkflow.flow.core.AsyncScope;
import com.amazonaws.services.simpleworkflow.flow.core.AsyncStackTrace;
import com.amazonaws.services.simpleworkflow.flow.core.AsyncTaskInfo;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.core.TryCatchFinally;
import java.util.List;
import java.util.concurrent.Executor;

class AsyncScopeContext {
    private final AsyncScope asyncScope;
    private boolean complete;
    private Throwable failure;
    private AsyncEventLoop executor;
    private TryCatchFinally root;
    private AsyncStackTrace stackTrace;
    private String name;

    public AsyncScopeContext(AsyncScope asyncScope, boolean disableAsyncStackTrace, boolean excludeAsyncScopeStack) {
        this.asyncScope = asyncScope;
        if (!disableAsyncStackTrace) {
            this.stackTrace = new AsyncStackTrace(null, new StackTraceElement[0], 0);
        }
        this.executor = new AsyncEventLoop();
        RootAsyncContext rootContext = new RootAsyncContext();
        AsyncContextBase.setCurrent(rootContext);
        try {
            int skipStackLines = excludeAsyncScopeStack ? Integer.MAX_VALUE : 10;
            this.root = new RootTryCatchFinally(false, skipStackLines);
        }
        finally {
            AsyncContextBase.setCurrent(null);
        }
    }

    public boolean eventLoop() throws Throwable {
        if (this.complete) {
            throw new IllegalStateException("already complete");
        }
        this.executor.executeAllQueued();
        if (this.complete && this.failure != null) {
            throw this.failure;
        }
        return this.complete;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public Throwable getFailure() {
        return this.failure;
    }

    public void cancel(Throwable cause) {
        this.root.cancel(cause);
    }

    public boolean isCancelRequested() {
        return this.root.isCancelRequested();
    }

    public List<AsyncTaskInfo> getAsynchronousStackTraceDump() {
        return this.root.getAsynchronousStackTraceDump();
    }

    public String getAsynchronousStackTraceDumpAsString() {
        return this.root.getAsynchronousStackTraceDumpAsString();
    }

    public AsyncParentContext getRootContext() {
        return this.root.getContext();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private final class RootAsyncContext
    implements AsyncParentContext {
        private RootAsyncContext() {
        }

        @Override
        public void remove(AsyncContextBase async) {
            assert (!AsyncScopeContext.this.complete);
            AsyncScopeContext.this.complete = true;
        }

        @Override
        public Executor getExecutor() {
            return AsyncScopeContext.this.executor;
        }

        @Override
        public void fail(AsyncContextBase async, Throwable e) {
            assert (!AsyncScopeContext.this.complete);
            AsyncScopeContext.this.failure = e;
            AsyncScopeContext.this.complete = true;
        }

        @Override
        public void add(AsyncContextBase async, Promise<?> waitFor) {
            if (waitFor != null) {
                throw new IllegalArgumentException();
            }
            AsyncScopeContext.this.executor.execute(async);
        }

        @Override
        public AsyncStackTrace getStackTrace() {
            return AsyncScopeContext.this.stackTrace;
        }

        @Override
        public boolean isRethrown(Throwable e) {
            throw new IllegalStateException("should not be called");
        }

        @Override
        public AsyncParentContext getCurrentTryCatchFinallyContext() {
            throw new IllegalStateException("should not be called");
        }

        @Override
        public boolean getDaemonFlagForHeir() {
            return false;
        }

        @Override
        public String getParentTaskMethodName() {
            return null;
        }

        @Override
        public boolean getHideStartFromMethod() {
            return false;
        }

        @Override
        public String getName() {
            return AsyncScopeContext.this.name;
        }
    }

    private final class RootTryCatchFinally
    extends TryCatchFinally {
        private RootTryCatchFinally(boolean daemon, int skipStackLines) {
            super((Boolean)daemon, "doAsync", skipStackLines, new Promise[0]);
        }

        @Override
        protected void doTry() throws Throwable {
            AsyncScopeContext.this.asyncScope.doAsync();
        }

        @Override
        protected void doCatch(Throwable e) throws Throwable {
            throw e;
        }

        @Override
        protected void doFinally() {
        }

        @Override
        AsyncParentContext getContext() {
            if (super.getState() != TryCatchFinally.State.CREATED && super.getState() != TryCatchFinally.State.TRYING) {
                throw new IllegalStateException("Already executed");
            }
            return super.getContext();
        }
    }
}

