/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.codecommit.model.Location;

@SdkInternalApi
public class LocationMarshaller {
    private static final MarshallingInfo<String> FILEPATH_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("filePath").build();
    private static final MarshallingInfo<Long> FILEPOSITION_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("filePosition").build();
    private static final MarshallingInfo<String> RELATIVEFILEVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("relativeFileVersion").build();
    private static final LocationMarshaller instance = new LocationMarshaller();

    public static LocationMarshaller getInstance() {
        return instance;
    }

    public void marshall(Location location, ProtocolMarshaller protocolMarshaller) {
        if (location == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(location.getFilePath(), FILEPATH_BINDING);
            protocolMarshaller.marshall(location.getFilePosition(), FILEPOSITION_BINDING);
            protocolMarshaller.marshall(location.getRelativeFileVersion(), RELATIVEFILEVERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

