/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.builder.states;

import com.amazonaws.annotation.SdkInternalApi;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;

@SdkInternalApi
final class PathContainer {
    @JsonProperty(value="InputPath")
    @JsonSerialize(using=PathSerializer.class)
    private final JsonNode inputPath;
    @JsonProperty(value="OutputPath")
    @JsonSerialize(using=PathSerializer.class)
    private final JsonNode outputPath;
    @JsonProperty(value="ResultPath")
    @JsonSerialize(using=PathSerializer.class)
    private final JsonNode resultPath;

    private PathContainer(Builder builder) {
        this.inputPath = builder.inputPath;
        this.outputPath = builder.outputPath;
        this.resultPath = builder.resultPath;
    }

    @JsonIgnore
    public String getInputPath() {
        return this.nodeToString(this.inputPath);
    }

    @JsonIgnore
    public String getOutputPath() {
        return this.nodeToString(this.outputPath);
    }

    @JsonIgnore
    public String getResultPath() {
        return this.nodeToString(this.resultPath);
    }

    private String nodeToString(JsonNode jsonNode) {
        if (jsonNode == null || jsonNode instanceof NullNode) {
            return null;
        }
        return jsonNode.asText();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class PathSerializer
    extends JsonSerializer<JsonNode> {
        private PathSerializer() {
        }

        public void serialize(JsonNode value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            if (value instanceof NullNode) {
                gen.writeNull();
            } else if (value instanceof TextNode) {
                gen.writeString(value.textValue());
            } else {
                throw new IllegalArgumentException("Unexpected value type: " + value);
            }
        }
    }

    public static final class Builder {
        private JsonNode inputPath;
        private JsonNode outputPath;
        private JsonNode resultPath;

        protected Builder() {
        }

        public Builder inputPath(String inputPath) {
            this.inputPath = this.resolvePath(inputPath);
            return this;
        }

        public Builder outputPath(String outputPath) {
            this.outputPath = this.resolvePath(outputPath);
            return this;
        }

        public Builder resultPath(String inputPath) {
            this.resultPath = this.resolvePath(inputPath);
            return this;
        }

        private JsonNode resolvePath(String pathString) {
            if (pathString == null) {
                return NullNode.getInstance();
            }
            return TextNode.valueOf((String)pathString);
        }

        public PathContainer build() {
            return new PathContainer(this);
        }
    }
}

