/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.directory.model.Computer;
import java.util.List;

@SdkInternalApi
public class ComputerMarshaller {
    private static final MarshallingInfo<String> COMPUTERID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComputerId").build();
    private static final MarshallingInfo<String> COMPUTERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComputerName").build();
    private static final MarshallingInfo<List> COMPUTERATTRIBUTES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComputerAttributes").build();
    private static final ComputerMarshaller instance = new ComputerMarshaller();

    public static ComputerMarshaller getInstance() {
        return instance;
    }

    public void marshall(Computer computer, ProtocolMarshaller protocolMarshaller) {
        if (computer == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(computer.getComputerId(), COMPUTERID_BINDING);
            protocolMarshaller.marshall(computer.getComputerName(), COMPUTERNAME_BINDING);
            protocolMarshaller.marshall(computer.getComputerAttributes(), COMPUTERATTRIBUTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

