/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.clouddirectory.model.FacetAttributeType;
import com.amazonaws.services.clouddirectory.model.Rule;
import com.amazonaws.services.clouddirectory.model.TypedAttributeValue;
import com.amazonaws.services.clouddirectory.model.transform.FacetAttributeDefinitionMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class FacetAttributeDefinition
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private TypedAttributeValue defaultValue;
    private Boolean isImmutable;
    private Map<String, Rule> rules;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public FacetAttributeDefinition withType(String type) {
        this.setType(type);
        return this;
    }

    public void setType(FacetAttributeType type) {
        this.withType(type);
    }

    public FacetAttributeDefinition withType(FacetAttributeType type) {
        this.type = type.toString();
        return this;
    }

    public void setDefaultValue(TypedAttributeValue defaultValue) {
        this.defaultValue = defaultValue;
    }

    public TypedAttributeValue getDefaultValue() {
        return this.defaultValue;
    }

    public FacetAttributeDefinition withDefaultValue(TypedAttributeValue defaultValue) {
        this.setDefaultValue(defaultValue);
        return this;
    }

    public void setIsImmutable(Boolean isImmutable) {
        this.isImmutable = isImmutable;
    }

    public Boolean getIsImmutable() {
        return this.isImmutable;
    }

    public FacetAttributeDefinition withIsImmutable(Boolean isImmutable) {
        this.setIsImmutable(isImmutable);
        return this;
    }

    public Boolean isImmutable() {
        return this.isImmutable;
    }

    public Map<String, Rule> getRules() {
        return this.rules;
    }

    public void setRules(Map<String, Rule> rules) {
        this.rules = rules;
    }

    public FacetAttributeDefinition withRules(Map<String, Rule> rules) {
        this.setRules(rules);
        return this;
    }

    public FacetAttributeDefinition addRulesEntry(String key, Rule value) {
        if (null == this.rules) {
            this.rules = new HashMap<String, Rule>();
        }
        if (this.rules.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.rules.put(key, value);
        return this;
    }

    public FacetAttributeDefinition clearRulesEntries() {
        this.rules = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getDefaultValue() != null) {
            sb.append("DefaultValue: ").append(this.getDefaultValue()).append(",");
        }
        if (this.getIsImmutable() != null) {
            sb.append("IsImmutable: ").append(this.getIsImmutable()).append(",");
        }
        if (this.getRules() != null) {
            sb.append("Rules: ").append(this.getRules());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FacetAttributeDefinition)) {
            return false;
        }
        FacetAttributeDefinition other = (FacetAttributeDefinition)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getDefaultValue() == null ^ this.getDefaultValue() == null) {
            return false;
        }
        if (other.getDefaultValue() != null && !other.getDefaultValue().equals(this.getDefaultValue())) {
            return false;
        }
        if (other.getIsImmutable() == null ^ this.getIsImmutable() == null) {
            return false;
        }
        if (other.getIsImmutable() != null && !other.getIsImmutable().equals(this.getIsImmutable())) {
            return false;
        }
        if (other.getRules() == null ^ this.getRules() == null) {
            return false;
        }
        return other.getRules() == null || other.getRules().equals(this.getRules());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultValue() == null ? 0 : this.getDefaultValue().hashCode());
        hashCode = 31 * hashCode + (this.getIsImmutable() == null ? 0 : this.getIsImmutable().hashCode());
        hashCode = 31 * hashCode + (this.getRules() == null ? 0 : this.getRules().hashCode());
        return hashCode;
    }

    public FacetAttributeDefinition clone() {
        try {
            return (FacetAttributeDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FacetAttributeDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

