/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

public class ValidationUtils {
    public static <T> T assertNotNull(T object, String fieldName) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(String.format("%s cannot be null", fieldName));
        }
        return object;
    }

    public static void assertAllAreNull(String messageIfNull, Object ... objects) throws IllegalArgumentException {
        for (Object object : objects) {
            if (object == null) continue;
            throw new IllegalArgumentException(messageIfNull);
        }
    }

    public static int assertIsPositive(int num, String fieldName) {
        if (num <= 0) {
            throw new IllegalArgumentException(String.format("%s must be positive", fieldName));
        }
        return num;
    }
}

