/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBDeleteExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperTableModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBQueryExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBSaveExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBScanExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.PaginatedParallelScanList;
import com.amazonaws.services.dynamodbv2.datamodeling.PaginatedScanList;
import com.amazonaws.services.dynamodbv2.datamodeling.QueryResultPage;
import com.amazonaws.services.dynamodbv2.datamodeling.S3ClientCache;
import com.amazonaws.services.dynamodbv2.datamodeling.S3Link;
import com.amazonaws.services.dynamodbv2.datamodeling.ScanResultPage;
import com.amazonaws.services.dynamodbv2.model.ConditionalCheckFailedException;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ResourceInUseException;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.s3.model.Region;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DynamoDBTableMapper<T, H, R> {
    private static final Log LOG = LogFactory.getLog(DynamoDBTableMapper.class);
    private final DynamoDBMapperTableModel<T> model;
    private final DynamoDBMapperFieldModel<T, H> hk;
    private final DynamoDBMapperFieldModel<T, R> rk;
    private final DynamoDBMapper mapper;
    private final AmazonDynamoDB db;

    protected DynamoDBTableMapper(DynamoDBMapperTableModel<T> model, DynamoDBMapper mapper, AmazonDynamoDB db) {
        this.rk = model.rangeKeyIfExists();
        this.hk = model.hashKey();
        this.model = model;
        this.mapper = mapper;
        this.db = db;
    }

    public <V> DynamoDBMapperFieldModel<T, V> field(String attributeName) {
        return this.model.field(attributeName);
    }

    public DynamoDBMapperFieldModel<T, H> hashKey() {
        return this.model.hashKey();
    }

    public DynamoDBMapperFieldModel<T, R> rangeKey() {
        return this.model.rangeKey();
    }

    public final List<T> batchLoad(Iterable<T> itemsToGet) {
        Map<String, List<Object>> results = this.mapper.batchLoad(itemsToGet);
        return results.isEmpty() ? Collections.emptyList() : results.get(this.model.tableName());
    }

    public final List<DynamoDBMapper.FailedBatch> batchSave(Iterable<T> objectsToSave) {
        return this.mapper.batchWrite(objectsToSave, Collections.emptyList());
    }

    public final List<DynamoDBMapper.FailedBatch> batchDelete(Iterable<T> objectsToDelete) {
        return this.mapper.batchWrite(Collections.emptyList(), objectsToDelete);
    }

    public final List<DynamoDBMapper.FailedBatch> batchWrite(Iterable<T> objectsToWrite, Iterable<T> objectsToDelete) {
        return this.mapper.batchWrite(objectsToWrite, objectsToDelete);
    }

    public final T load(H hashKey) {
        return this.mapper.load(this.model.targetType(), hashKey);
    }

    public final T load(H hashKey, R rangeKey) {
        return this.mapper.load(this.model.targetType(), hashKey, rangeKey);
    }

    public final void save(T object) {
        this.mapper.save(object);
    }

    public final void save(T object, DynamoDBSaveExpression saveExpression) {
        this.mapper.save(object, saveExpression);
    }

    public final void saveIfNotExists(T object) throws ConditionalCheckFailedException {
        DynamoDBSaveExpression saveExpression = new DynamoDBSaveExpression();
        saveExpression.withExpectedEntry(this.hk.name(), this.hk.expectedNotExists());
        if (this.rk != null) {
            saveExpression.withExpectedEntry(this.rk.name(), this.rk.expectedNotExists());
        }
        this.mapper.save(object, saveExpression);
    }

    public final void saveIfExists(T object) throws ConditionalCheckFailedException {
        DynamoDBSaveExpression saveExpression = new DynamoDBSaveExpression();
        saveExpression.withExpectedEntry(this.hk.name(), this.hk.expectedExists(this.hk.get(object)));
        if (this.rk != null) {
            saveExpression.withExpectedEntry(this.rk.name(), this.rk.expectedExists(this.rk.get(object)));
        }
        this.mapper.save(object, saveExpression);
    }

    public final void delete(T object) {
        this.mapper.delete(object);
    }

    public final void delete(T object, DynamoDBDeleteExpression deleteExpression) {
        this.mapper.delete(object, deleteExpression);
    }

    public final void deleteIfExists(T object) throws ConditionalCheckFailedException {
        DynamoDBDeleteExpression deleteExpression = new DynamoDBDeleteExpression();
        deleteExpression.withExpectedEntry(this.hk.name(), this.hk.expectedExists(this.hk.get(object)));
        if (this.rk != null) {
            deleteExpression.withExpectedEntry(this.rk.name(), this.rk.expectedExists(this.rk.get(object)));
        }
        this.mapper.delete(object, deleteExpression);
    }

    public final int count(DynamoDBQueryExpression<T> queryExpression) {
        return this.mapper.count(this.model.targetType(), queryExpression);
    }

    public final QueryResultPage<T> query(DynamoDBQueryExpression<T> queryExpression) {
        return this.mapper.queryPage(this.model.targetType(), queryExpression);
    }

    public final QueryResultPage<T> queryPage(DynamoDBQueryExpression<T> queryExpression) {
        return this.mapper.queryPage(this.model.targetType(), queryExpression);
    }

    public final DynamoDBQueryExpression<T> expressionForKey(H hashKey) {
        return new DynamoDBQueryExpression<T>().withHashKeyValues(this.model.newKey(hashKey, null));
    }

    public final int count(DynamoDBScanExpression scanExpression) {
        return this.mapper.count(this.model.targetType(), scanExpression);
    }

    public final PaginatedScanList<T> scan(DynamoDBScanExpression scanExpression) {
        return this.mapper.scan(this.model.targetType(), scanExpression);
    }

    public final ScanResultPage<T> scanPage(DynamoDBScanExpression scanExpression) {
        return this.mapper.scanPage(this.model.targetType(), scanExpression);
    }

    public final PaginatedParallelScanList<T> parallelScan(DynamoDBScanExpression scanExpression, int totalSegments) {
        return this.mapper.parallelScan(this.model.targetType(), scanExpression, totalSegments);
    }

    public final S3Link createS3Link(Region s3region, String bucketName, String key) {
        return this.mapper.createS3Link(s3region, bucketName, key);
    }

    public final S3Link createS3Link(String bucketName, String key) {
        return this.mapper.createS3Link(bucketName, key);
    }

    public final S3ClientCache getS3ClientCache() {
        return this.mapper.getS3ClientCache();
    }

    public final TableDescription describeTable() {
        return this.db.describeTable(this.model.tableName()).getTable();
    }

    public final boolean createTableIfNotExists(ProvisionedThroughput throughput) {
        try {
            this.db.createTable(this.mapper.generateCreateTableRequest(this.model.targetType()).withProvisionedThroughput(throughput));
        }
        catch (ResourceInUseException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Table " + this.model.tableName() + " already exists, no need to create"), (Throwable)e);
            }
            return false;
        }
        return true;
    }

    public final boolean deleteTableIfExists() {
        try {
            this.db.deleteTable(this.mapper.generateDeleteTableRequest(this.model.targetType()));
        }
        catch (ResourceNotFoundException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Table " + this.model.tableName() + " does not exist, no need to delete"), (Throwable)e);
            }
            return false;
        }
        return true;
    }
}

