/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.snowball.model.Shipment;

@SdkInternalApi
public class ShipmentMarshaller {
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> TRACKINGNUMBER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrackingNumber").build();
    private static final ShipmentMarshaller instance = new ShipmentMarshaller();

    public static ShipmentMarshaller getInstance() {
        return instance;
    }

    public void marshall(Shipment shipment, ProtocolMarshaller protocolMarshaller) {
        if (shipment == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(shipment.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(shipment.getTrackingNumber(), TRACKINGNUMBER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

