/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.services.route53.model.ResourceTagSet;
import com.amazonaws.services.route53.model.Tag;
import com.amazonaws.services.route53.model.transform.TagStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class ResourceTagSetStaxUnmarshaller
implements Unmarshaller<ResourceTagSet, StaxUnmarshallerContext> {
    private static ResourceTagSetStaxUnmarshaller instance;

    @Override
    public ResourceTagSet unmarshall(StaxUnmarshallerContext context) throws Exception {
        ResourceTagSet resourceTagSet = new ResourceTagSet();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return resourceTagSet;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ResourceType", targetDepth)) {
                    resourceTagSet.setResourceType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ResourceId", targetDepth)) {
                    resourceTagSet.setResourceId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Tags", targetDepth)) {
                    resourceTagSet.withTags(new ArrayList<Tag>());
                    continue;
                }
                if (!context.testExpression("Tags/Tag", targetDepth)) continue;
                resourceTagSet.withTags(TagStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return resourceTagSet;
    }

    public static ResourceTagSetStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ResourceTagSetStaxUnmarshaller();
        }
        return instance;
    }
}

