/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexmodelbuilding.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lexmodelbuilding.model.Locale;
import com.amazonaws.services.lexmodelbuilding.model.transform.BuiltinSlotTypeMetadataMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BuiltinSlotTypeMetadata
implements Serializable,
Cloneable,
StructuredPojo {
    private String signature;
    private List<String> supportedLocales;

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getSignature() {
        return this.signature;
    }

    public BuiltinSlotTypeMetadata withSignature(String signature) {
        this.setSignature(signature);
        return this;
    }

    public List<String> getSupportedLocales() {
        return this.supportedLocales;
    }

    public void setSupportedLocales(Collection<String> supportedLocales) {
        if (supportedLocales == null) {
            this.supportedLocales = null;
            return;
        }
        this.supportedLocales = new ArrayList<String>(supportedLocales);
    }

    public BuiltinSlotTypeMetadata withSupportedLocales(String ... supportedLocales) {
        if (this.supportedLocales == null) {
            this.setSupportedLocales(new ArrayList<String>(supportedLocales.length));
        }
        for (String ele : supportedLocales) {
            this.supportedLocales.add(ele);
        }
        return this;
    }

    public BuiltinSlotTypeMetadata withSupportedLocales(Collection<String> supportedLocales) {
        this.setSupportedLocales(supportedLocales);
        return this;
    }

    public BuiltinSlotTypeMetadata withSupportedLocales(Locale ... supportedLocales) {
        ArrayList<String> supportedLocalesCopy = new ArrayList<String>(supportedLocales.length);
        for (Locale value : supportedLocales) {
            supportedLocalesCopy.add(value.toString());
        }
        if (this.getSupportedLocales() == null) {
            this.setSupportedLocales(supportedLocalesCopy);
        } else {
            this.getSupportedLocales().addAll(supportedLocalesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSignature() != null) {
            sb.append("Signature: ").append(this.getSignature()).append(",");
        }
        if (this.getSupportedLocales() != null) {
            sb.append("SupportedLocales: ").append(this.getSupportedLocales());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuiltinSlotTypeMetadata)) {
            return false;
        }
        BuiltinSlotTypeMetadata other = (BuiltinSlotTypeMetadata)obj;
        if (other.getSignature() == null ^ this.getSignature() == null) {
            return false;
        }
        if (other.getSignature() != null && !other.getSignature().equals(this.getSignature())) {
            return false;
        }
        if (other.getSupportedLocales() == null ^ this.getSupportedLocales() == null) {
            return false;
        }
        return other.getSupportedLocales() == null || other.getSupportedLocales().equals(this.getSupportedLocales());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSignature() == null ? 0 : this.getSignature().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedLocales() == null ? 0 : this.getSupportedLocales().hashCode());
        return hashCode;
    }

    public BuiltinSlotTypeMetadata clone() {
        try {
            return (BuiltinSlotTypeMetadata)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BuiltinSlotTypeMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

