/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.CopyOptionGroupRequest;
import com.amazonaws.services.rds.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CopyOptionGroupRequestMarshaller
implements Marshaller<Request<CopyOptionGroupRequest>, CopyOptionGroupRequest> {
    @Override
    public Request<CopyOptionGroupRequest> marshall(CopyOptionGroupRequest copyOptionGroupRequest) {
        SdkInternalList tagsList;
        if (copyOptionGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CopyOptionGroupRequest> request = new DefaultRequest<CopyOptionGroupRequest>(copyOptionGroupRequest, "AmazonRDS");
        request.addParameter("Action", "CopyOptionGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (copyOptionGroupRequest.getSourceOptionGroupIdentifier() != null) {
            request.addParameter("SourceOptionGroupIdentifier", StringUtils.fromString(copyOptionGroupRequest.getSourceOptionGroupIdentifier()));
        }
        if (copyOptionGroupRequest.getTargetOptionGroupIdentifier() != null) {
            request.addParameter("TargetOptionGroupIdentifier", StringUtils.fromString(copyOptionGroupRequest.getTargetOptionGroupIdentifier()));
        }
        if (copyOptionGroupRequest.getTargetOptionGroupDescription() != null) {
            request.addParameter("TargetOptionGroupDescription", StringUtils.fromString(copyOptionGroupRequest.getTargetOptionGroupDescription()));
        }
        if (!(tagsList = (SdkInternalList)copyOptionGroupRequest.getTags()).isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

