/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mobile.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mobile.model.Platform;
import com.amazonaws.services.mobile.model.transform.BundleDetailsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BundleDetails
implements Serializable,
Cloneable,
StructuredPojo {
    private String bundleId;
    private String title;
    private String version;
    private String description;
    private String iconUrl;
    private List<String> availablePlatforms;

    public void setBundleId(String bundleId) {
        this.bundleId = bundleId;
    }

    public String getBundleId() {
        return this.bundleId;
    }

    public BundleDetails withBundleId(String bundleId) {
        this.setBundleId(bundleId);
        return this;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public BundleDetails withTitle(String title) {
        this.setTitle(title);
        return this;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public BundleDetails withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public BundleDetails withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public BundleDetails withIconUrl(String iconUrl) {
        this.setIconUrl(iconUrl);
        return this;
    }

    public List<String> getAvailablePlatforms() {
        return this.availablePlatforms;
    }

    public void setAvailablePlatforms(Collection<String> availablePlatforms) {
        if (availablePlatforms == null) {
            this.availablePlatforms = null;
            return;
        }
        this.availablePlatforms = new ArrayList<String>(availablePlatforms);
    }

    public BundleDetails withAvailablePlatforms(String ... availablePlatforms) {
        if (this.availablePlatforms == null) {
            this.setAvailablePlatforms(new ArrayList<String>(availablePlatforms.length));
        }
        for (String ele : availablePlatforms) {
            this.availablePlatforms.add(ele);
        }
        return this;
    }

    public BundleDetails withAvailablePlatforms(Collection<String> availablePlatforms) {
        this.setAvailablePlatforms(availablePlatforms);
        return this;
    }

    public BundleDetails withAvailablePlatforms(Platform ... availablePlatforms) {
        ArrayList<String> availablePlatformsCopy = new ArrayList<String>(availablePlatforms.length);
        for (Platform value : availablePlatforms) {
            availablePlatformsCopy.add(value.toString());
        }
        if (this.getAvailablePlatforms() == null) {
            this.setAvailablePlatforms(availablePlatformsCopy);
        } else {
            this.getAvailablePlatforms().addAll(availablePlatformsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBundleId() != null) {
            sb.append("BundleId: ").append(this.getBundleId()).append(",");
        }
        if (this.getTitle() != null) {
            sb.append("Title: ").append(this.getTitle()).append(",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getIconUrl() != null) {
            sb.append("IconUrl: ").append(this.getIconUrl()).append(",");
        }
        if (this.getAvailablePlatforms() != null) {
            sb.append("AvailablePlatforms: ").append(this.getAvailablePlatforms());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BundleDetails)) {
            return false;
        }
        BundleDetails other = (BundleDetails)obj;
        if (other.getBundleId() == null ^ this.getBundleId() == null) {
            return false;
        }
        if (other.getBundleId() != null && !other.getBundleId().equals(this.getBundleId())) {
            return false;
        }
        if (other.getTitle() == null ^ this.getTitle() == null) {
            return false;
        }
        if (other.getTitle() != null && !other.getTitle().equals(this.getTitle())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getIconUrl() == null ^ this.getIconUrl() == null) {
            return false;
        }
        if (other.getIconUrl() != null && !other.getIconUrl().equals(this.getIconUrl())) {
            return false;
        }
        if (other.getAvailablePlatforms() == null ^ this.getAvailablePlatforms() == null) {
            return false;
        }
        return other.getAvailablePlatforms() == null || other.getAvailablePlatforms().equals(this.getAvailablePlatforms());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBundleId() == null ? 0 : this.getBundleId().hashCode());
        hashCode = 31 * hashCode + (this.getTitle() == null ? 0 : this.getTitle().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getIconUrl() == null ? 0 : this.getIconUrl().hashCode());
        hashCode = 31 * hashCode + (this.getAvailablePlatforms() == null ? 0 : this.getAvailablePlatforms().hashCode());
        return hashCode;
    }

    public BundleDetails clone() {
        try {
            return (BundleDetails)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BundleDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

