/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.ConnectionInput;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class ConnectionInputMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> CONNECTIONTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectionType").build();
    private static final MarshallingInfo<List> MATCHCRITERIA_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MatchCriteria").build();
    private static final MarshallingInfo<Map> CONNECTIONPROPERTIES_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectionProperties").build();
    private static final MarshallingInfo<StructuredPojo> PHYSICALCONNECTIONREQUIREMENTS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PhysicalConnectionRequirements").build();
    private static final ConnectionInputMarshaller instance = new ConnectionInputMarshaller();

    public static ConnectionInputMarshaller getInstance() {
        return instance;
    }

    public void marshall(ConnectionInput connectionInput, ProtocolMarshaller protocolMarshaller) {
        if (connectionInput == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(connectionInput.getName(), NAME_BINDING);
            protocolMarshaller.marshall(connectionInput.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(connectionInput.getConnectionType(), CONNECTIONTYPE_BINDING);
            protocolMarshaller.marshall(connectionInput.getMatchCriteria(), MATCHCRITERIA_BINDING);
            protocolMarshaller.marshall(connectionInput.getConnectionProperties(), CONNECTIONPROPERTIES_BINDING);
            protocolMarshaller.marshall(connectionInput.getPhysicalConnectionRequirements(), PHYSICALCONNECTIONREQUIREMENTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

